/*
 * mplug-unix.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

//#ifndef lint
//static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/mplug/unix/mplug-unix.cc,v 1.8 2002/02/03 04:12:52 lim Exp $";
//#endif


#include "../mplug-compat.h"
#include "mplug-unix.h"


char* PluginInstance::mimeDescription =
"application/x-sd:sdp:Session Description Protocol;"
"x-mash/x-script:mash:MASH Script;x-mash/x-msp:msp:MASH Streaming Protocol";

char* PluginInstance::pluginName = "MPlug";
char* PluginInstance::pluginDescription =
"MASH Plugin. URL: http://www.openmash.org/";



NPError
PluginInstance::Initialize(void)
{
	return NPERR_NO_ERROR;
}


void
PluginInstance::Shutdown(void)
{
}



UnixMPlugInstance::UnixMPlugInstance(NPMIMEType mimeType, NPP instance,
				     uint16 mode, int16 argc,
				     const char * const *argn,
				     const char * const *argv)
	: MPlugInstance(mimeType, instance, mode, argc, argn, argv),
	  window_(0)
#ifdef NETSCAPE_RESIZE_BUG
	, parentWidget_(NULL)
#endif
{
}


UnixMPlugInstance::~UnixMPlugInstance()
{
	DeleteWindow();
}


NPError
UnixMPlugInstance::NewWindow(NPWindow *npWindow)
{
	NPError retval;

	LOG(("UnixMPlugInstance::NewWindow invoked\n"));
	window_ = (Window) npWindow->window;
	retval = MPlugInstance::NewWindow(npWindow);
	if (retval!=NPERR_NO_ERROR) {
		LOG(("UnixMPlugInstance::NewWindow returning an error\n"));
		return retval;
	}

#ifdef NETSCAPE_RESIZE_BUG
	if (mode()==NP_FULL) {
		// Communicator4.0 has a bug (I think!) where NPP_SetWindow
		// does not get called when the user resizes the Netscape
		// window, so I'm trying to get around it by setting up
		// my own event handler
		Display *display = ((NPSetWindowCallbackStruct*)
				    npWindow->ws_info)->display;
		parentWidget_ = XtParent(XtWindowToWidget(display, window_));
		XtAddEventHandler(parentWidget_, StructureNotifyMask,
				  FALSE, StructureNotifyHandler, this);
	}
#endif

	LOG(("UnixMPlugInstance::NewWindow returning successfully\n"));
	return retval;
}


#ifdef NETSCAPE_RESIZE_BUG
void
UnixMPlugInstance::StructureNotifyHandler(Widget /*w*/, XtPointer closure,
					  XEvent *event, Boolean */*dummy*/)
{
	LOG(("UnixMPlugInstance::StructureNotifyHandler called\n"));
	if (event->type==ConfigureNotify) {
		UnixMPlugInstance* This = (UnixMPlugInstance*)closure;
		XResizeWindow(event->xconfigure.display, This->window_,
			      event->xconfigure.width,
			      event->xconfigure.height);
		This->NotifyReconfigure(event->xconfigure.width,
					event->xconfigure.height);
	}
	LOG(("UnixMPlugInstance::StructureNotifyHandler exiting\n"));
}
#endif


NPError
UnixMPlugInstance::ReconfigureWindow(NPWindow *npWindow)
{
	XResizeWindow(((NPSetWindowCallbackStruct*)npWindow->ws_info)->display,
		      window_, npWindow->width, npWindow->height);
	if (MPlugInstance::NotifyReconfigure(npWindow->width,
					     npWindow->height)) {
		return NPERR_NO_ERROR;
	} else {
		return NPERR_GENERIC_ERROR;
	}
}


NPError
UnixMPlugInstance::DeleteWindow()
{
#ifdef NETSCAPE_RESIZE_BUG
	if (mode()==NP_FULL && parentWidget_)
		XtRemoveEventHandler(parentWidget_, StructureNotifyMask,
				     FALSE, StructureNotifyHandler, this);
#endif

	window_ = (Window) NULL;
	return NPERR_NO_ERROR;
}


const char *
UnixMPlugInstance::GetDisplay(NPWindow *npWindow)
{
	/*
	 * obtain the name of the display on which to start up the
	 * Tcl application. This should be the same as the display
	 * on which the browser is running!
	 */

	Display *display = ((NPSetWindowCallbackStruct*)
			    npWindow->ws_info)->display;
	const char *displayStr = DisplayString(display);
	if (displayStr==NULL || *displayStr=='\0') displayStr = ":0.0";

	/*
	 * while we are here, flush all X events;
	 * this allows the parent window to actually get created before
	 * we create the plugin process
	 */
	XFlush(display);

	return displayStr;
}

