/*
 * mb-apprcvr.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-apprcvr.cc,v 1.21 2002/02/03 03:16:30 lim Exp $
 */

#include "mb/mb-rcvr.h"
#include "mb/mb-mgr.h"


MBReceiver::MBReceiver(MBManager* pMgr, const SrcId& sid)
	: MBBaseRcvr(pMgr, sid)
{
}

// returns an canvId that is the most recent among those between
// mostRecent and timestamp and update mostRecent;
// if cannot find a more recent one, return zero
CanvItemId MBReceiver::FindMostRecent(PageId pid, n_long& mostRecent,
                                      n_long timestamp)
{
	Page* pPage=(Page*)DefinePage(pid);
	if (pPage) {
		return pPage->FindMostRecent(mostRecent, timestamp);
	}
	else return 0;
}

int
MBReceiver::executeCmd(MBCmd* pCmd, MBPageObject *pPage,
		       const MBTime& oldTime, const MBTime& newTime)
{
	pCmd->rcvr(this);
	int retcode=pCmd->execute((Page*)pPage, oldTime, newTime);
	if (retcode != MB_EXE_OK)
		return retcode;
	((MBManager*)getMgr())->Rearrange(pPage, pCmd);
	return retcode;
}

Bool
MBLocalReceiver::executeInteractive(MBCmd* pCmd, Page* pPage)
{
	/* FIXME: call activity? */
	if (!pCmd->executeInteractive(pPage)) {
		return FALSE;
	}
	n_long itemId = pCmd->getItemId();
	if (itemId)
		pPage->RaiseToFront(itemId);
	return TRUE;
}


// virtual /* from MBReceiver */
MBPageObject *
MBLocalReceiver::DefinePage(const PageId &pageId, Bool *newFlag)
{
	/* should update next_pg_uid here ? */
	if (pageId.sid.ss_uid==0 && pageId.sid.ss_addr==0 &&
	    pageId.uid==0) {
		fprintf(stderr, "Trying to define page id NULL\n");
		abort();
	}
	MBPageObject *pPage = MBBaseRcvr::DefinePage(pageId, newFlag);
	/* define page may return zero if we are in the middle
	 * of creating the page */
	if (pPage!=NULL) ((Page*)pPage)->SetLocal();
	return pPage;
}


//
// next_pg_uid might not be up-to-date if updates came from other receivers
// so we loop thru and try and define each page sequentially until a new
// page is created.
MBPageObject* MBLocalReceiver::NewPageObject()
{
	PageId pgid;
	pgid.sid = getSrcId();
	MBPageObject *pPage=NULL;
	Bool newFlag = FALSE;
	do {
		pgid.uid = next_pg_uid_++;
		pPage = DefinePage(pgid, &newFlag);
	} while (newFlag==FALSE);
	return pPage;
}

//
// Execute the command and ask the network to start pulling packets,
// if neccessary
//

Bool MBLocalReceiver::Dispatch(MBCmd* pCmd, Page* pPage)
{
	Bool retCode;
	// commands with null sn are local commands about to be executed
	// so we let them thru
	if (pCmd->getSeqno() && pPage->HasCmd(pCmd->getSeqno())) {
		char *szStr = ::PgId2Str(pPage->getId());
		Trace(EXCESSIVE,("Received duplicate pkt #%lu for page %s",
				 pCmd->getSeqno(), szStr));
		delete[] szStr;
		return TRUE;            // treat as okay
	}
	MBBaseMgr *pMgr = getMgr();
	retCode = handleCmd(pCmd, pPage, cMBTimeNegInf,
			    pPage->targetTime());
	if (retCode != MB_EXE_ERROR) {
		// - The execution of command is successful, therefore
		//   we have at least one packet to sent out.
		// - Ask the page if we need to ask the network to start
		//   pulling packets.
		// - NOTE:for now we don't send packets out of order
		//   which means pPage->RequestSendAmount is 0
		//   if we have more
		//   than one packet. (See Page::RequestSendAmount)
		if (pPage->isVisible()) {
			int nextAmt = pPage->RequestSendAmount();
			MTrace(trcMB|trcVerbose, ("nextAmt = %d\n", nextAmt));
			if (nextAmt)
				pMgr->RequestSend(nextAmt +
						  sizeof(Pkt_DataHdr));
		}
	}
	return (retCode == MB_EXE_OK);
}


//
// This means that a remote receiver has detected that this local
// receiver is outdated. Besides updating the the page state,
// We need to bump up the lastSent_ value of the page
void MBLocalReceiver::HandleSA(Pkt_PgStatus* aPgStatus, int numPgs)
{
	// note: when numPgs is zero the following loop is skipped
	for (Pkt_PgStatus* pPgStatus= aPgStatus;
	     pPgStatus < aPgStatus+numPgs;
	     pPgStatus++) {
		PageId pgid;
		net2host(pPgStatus->pageid, pgid);
		MBPageObject* pPage = DefinePage(pgid);
		ulong maxSn=net2host(pPgStatus->maxSn);
		pPage->Update(getSrcId(), maxSn);
		pPage->SetLastSent(maxSn);
	}
}

/*virtual*/
int
MBLocalReceiver::FillSA(Byte *pb, int len)
{
	int baselen = MBBaseRcvr::FillSA(pb, len-sizeof(Pkt_RcvrInfo));
	if (pCurrPage_) {
		assert(pCurrPage_->getId() != cNullPageId);
		Pkt_RcvrInfo* pInfoPkt = (Pkt_RcvrInfo*)(pb+baselen);
		host2net(pCurrPage_->getId(), pInfoPkt->currPageId);
		baselen += sizeof(Pkt_RcvrInfo);
	}
	return baselen;
}

int MBReceiver::warpTime(const PageId& pageId, const MBTime& toTime)
{
	MBPageObject* pPage = DefinePage(pageId);
	if (!pPage) {
		Tcl::instance().add_error("cannot find page");
		return TCL_ERROR;
	}
	return (DYN_CAST(Page*)(pPage))->warpTime(this, toTime);
}

int MBReceiver::timeRange(const PageId &pgId, MBTime& start, MBTime& end)
{
	Page* pPage = DYN_CAST(Page*)(DefinePage(pgId));
	return pPage->timeRange(pgId, start, end);
}
