/*
 * nv_stub.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/param.h>
#include <netinet/in.h>
#include "jpeg.h"

static YUVJpegDecoder* decoder;
extern void JVideoConfig(JpegDecoder::config& c, int w, int h, int q);

static DiffJpegDecoder* diffdecoder;

extern "C" {
#include "nv/video.h"

void jpeg_decode(vidimage_t *image, u_char *data, int len)
{
	u_short *hdr = (u_short*)data;
	int width = ntohs(hdr[0]);
	int height = ntohs(hdr[1]);
	int qFactor = ntohs(hdr[2]);
	data += 8;
	len -= 8;
	if (decoder == 0) {
		JpegDecoder::config config;
		JVideoConfig(config, width, height, qFactor);
		decoder = new YUVJpegDecoder(config);
	}
	/*FIXME hope there is room */
	data[len++] = 0xff;
	data[len++] = 0xd9; /* EOI */

	decoder->decode(data, len);

	u_short *syp = (u_short*)decoder->yplane();
	u_char *sup = decoder->uplane();
	u_char *svp = decoder->vplane();

	u_short *yp = (u_short*)image->y_data;
	u_char *uvp = (u_char*)image->uv_data;
	for (len = width * height; len >= 0; len -= 2) {
		*yp++ = *syp++;
		*uvp++ = *sup++ - 128;
		*uvp++ = *svp++ - 128;
	}
	VidImage_UpdateRect(image, 0, 0, width, height);
}

struct blkcache* init_jpegdiff(int w, int h, int q)
{
	JpegDecoder::config config;
	/*FIXME*/
	JVideoConfig(config, w, h, q);
	diffdecoder = new DiffJpegDecoder(config);
	return (diffdecoder->dcts);
}

void jpeg_getdiff(u_char* in, int len, struct blkcache* bc, u_char* diffvector)
{
	diffdecoder->decode(in, len, bc, diffvector);
}

}
