#!/bin/sh
# path trick for wish variants \
exec wish $0 ${1+"$@"}

# driver.tcl --
#
#       Test file for development of the vcc3 driver.  Not used in vcc3d.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

source ../../lib/tcl/sleep.tcl
source vcc3-api.tcl

proc InitUI {} {
    wm title . "VCC3 Driver"
    wm minsize . 150 0
    
    frame .select_frame
    pack .select_frame -fill x -side top

    # controls for moving the camera
    frame .controls_frame

    pack .controls_frame -side top

    frame .controls_frame.top -borderwidth 3
    frame .controls_frame.middle -borderwidth 3
    frame .controls_frame.bottom -borderwidth 3
    frame .controls_frame.bottom2 -borderwidth 3
    
    button .controls_frame.top.up -text " Up "
#    bind .controls_frame.top.up <Button-1> "vcc3_startUp"
    bind .controls_frame.top.up <Button-1> "vcc3_startMove up"
    bind .controls_frame.top.up <ButtonRelease-1> "vcc3_stop"
    
    button .controls_frame.middle.left -text "Left"
    bind .controls_frame.middle.left <Button-1> "vcc3_startLeft"
    bind .controls_frame.middle.left <ButtonRelease-1> "vcc3_stop"
    
    button .controls_frame.middle.center -text "Home" -width 4 -command "vcc3_home"

    button .controls_frame.middle.right -text "Right"
    bind .controls_frame.middle.right <Button-1> "vcc3_startRight"
    bind .controls_frame.middle.right <ButtonRelease-1> "vcc3_stop"

    button .controls_frame.bottom.down -text "Down"
    bind .controls_frame.bottom.down <Button-1> "vcc3_startDown"
    bind .controls_frame.bottom.down <ButtonRelease-1> "vcc3_stop"

    button .controls_frame.bottom2.in -text "In" -width 3
    bind .controls_frame.bottom2.in <Button-1> "vcc3_startIn"
    bind .controls_frame.bottom2.in <ButtonRelease-1> "vcc3_stop"
    button .controls_frame.bottom2.out -text "Out" -width 3
    bind .controls_frame.bottom2.out <Button-1> "vcc3_startOut"
    bind .controls_frame.bottom2.out <ButtonRelease-1> "vcc3_stop"
    
    pack .controls_frame.top -side top -fill x
    pack .controls_frame.top.up -side top

    pack .controls_frame.middle -side top
    pack .controls_frame.middle.left -side left
    pack .controls_frame.middle.center -side left
    pack .controls_frame.middle.right -side right
    
    pack .controls_frame.bottom -side top
    pack .controls_frame.bottom.down -side top

    pack .controls_frame.bottom2 -side top
    pack .controls_frame.bottom2.in -side left -ipadx 2
    pack .controls_frame.bottom2.out -side right -ipadx 2

    frame .presets
    pack .presets -fill x -side top
    
    frame .presets.set_frame
    pack .presets.set_frame -fill x -side top
    
    button .presets.set_frame.set1 -text "Set 1" -command "vcc3_setPreset 1"
    pack .presets.set_frame.set1 -side left
    button .presets.set_frame.set2 -text "Set 2" -command "vcc3_setPreset 2"
    pack .presets.set_frame.set2 -side left
    button .presets.set_frame.set3 -text "Set 3" -command "vcc3_setPreset 3"
    pack .presets.set_frame.set3 -side left
    button .presets.set_frame.set4 -text "Set 4" -command "vcc3_setPreset 4"
    pack .presets.set_frame.set4 -side left
    button .presets.set_frame.set5 -text "Set 5" -command "vcc3_setPreset 5"
    pack .presets.set_frame.set5 -side left
    button .presets.set_frame.set6 -text "Set 6" -command "vcc3_setPreset 6"
    pack .presets.set_frame.set6 -side left

    frame .presets.go_frame
    pack .presets.go_frame -fill x -side top

    button .presets.go_frame.set1 -text "Go 1" -command "vcc3_goPreset 1"
    pack .presets.go_frame.set1 -side left
    button .presets.go_frame.set2 -text "Go 2" -command "vcc3_goPreset 2"
    pack .presets.go_frame.set2 -side left
    button .presets.go_frame.set3 -text "Go 3" -command "vcc3_goPreset 3"
    pack .presets.go_frame.set3 -side left
    button .presets.go_frame.set4 -text "Go 4" -command "vcc3_goPreset 4"
    pack .presets.go_frame.set4 -side left
    button .presets.go_frame.set5 -text "Go 5" -command "vcc3_goPreset 5"
    pack .presets.go_frame.set5 -side left
    button .presets.go_frame.set6 -text "Go 6" -command "vcc3_goPreset 6"
    pack .presets.go_frame.set6 -side left

    button .fadeIn -text "Fade In" -command "vcc3_fadeIn"
    pack .fadeIn -side top
    button .fadeOut -text "Fade Out" -command "vcc3_fadeOut"
    pack .fadeOut -side top

    button .autoFocus -text "Auto Focus" -command "vcc3_setFocusMode auto"
    pack .autoFocus -side top
    button .manualFocus -text "Manual Focus" -command "vcc3_setFocusMode manual"
    pack .manualFocus
    
    button .focusNear -text "Focus Near"
    pack .focusNear -side top
    bind .focusNear <Button-1> "vcc3_startFocus near"
    bind .focusNear <ButtonRelease-1> "vcc3_stopFocus"
    
    button .focusFar -text "Focus Far"
    pack .focusFar -side top
    bind .focusFar <Button-1> "vcc3_startFocus far"
    bind .focusFar <ButtonRelease-1> "vcc3_stopFocus"

    button .reset -text "Reset" -command "vcc3_resetSoftware"
    pack .reset -side top
    
    button .init -text "Init" -command "vcc3_initCamera"
    pack .init -side top

    button .setup -text "Setup" -command "vcc3_setup"
    pack .setup -side top
    
    button .remote -text "Remote" -command "vcc3_disablePCControl"
    pack .remote -side top

    button .info -text "Info" -command "GetInfo"
    pack .info -side top

    button .test -text "Test" -command "vcc3_test"
    pack .test -side top

    
    # make exit button
    button .exit -text "Exit" -command "ExitApp"
    pack .exit -side bottom

    
}

proc ExitApp {} {
    vcc3_closeControl
    exit
}

proc GetInfo {} {
    if {0} {
	set panSpeed [vcc3_getPanSpeed]
	set tiltSpeed [vcc3_getTiltSpeed]
	set panPosition [vcc3_getPanPosition]
	set tiltPosition [vcc3_getTiltPosition]
	puts stdout "driver: panSpeed = $panSpeed, tiltSpeed = $tiltSpeed"
	puts stdout "driver: panPos = $panPosition, tiltPos = $tiltPosition"
	set zoomSpeed [vcc3_getZoomSpeed]
	set zoomPosition [vcc3_getZoomPosition]
	set maxZoom [vcc3_getMaxZoom]
	puts stdout "driver: zoomSpeed = $zoomSpeed, zoomPos = $zoomPosition"
	puts stdout "driver: maxZoom = $maxZoom"
    } else {
	set info [vcc3_getPanTiltInfo]
	set panSpeed [lindex $info 0]
	set tiltSpeed [lindex $info 1]
	set panPosition [lindex $info 2]
	set tiltPosition [lindex $info 3]
	puts stdout "driver: panSpeed = $panSpeed, tiltSpeed = $tiltSpeed"
	puts stdout "driver: panPos = $panPosition, tiltPos = $tiltPosition"
	set info [vcc3_getZoomInfo]
	set zoomSpeed [lindex $info 0]
	set zoomPosition [lindex $info 1]
	set maxZoom [lindex $info 2]
	puts stdout "driver: zoomSpeed = $zoomSpeed, zoomPos = $zoomPosition"
	puts stdout "driver: maxZoom = $maxZoom"

	for {set num 1} {$num < 7} {incr num 1} {
  	    set info [vcc3_getPresetInfo $num]
  	    set aeRef [lindex $info 0]
  	    set presetPanPos [lindex $info 1]
  	    set presetTiltPos [lindex $info 2]
  	    set presetZoomPos [lindex $info 3]
  	    puts stdout "driver: preset $num: aeRef=$aeRef, panPos=$presetPanPos, tiltPos=$presetTiltPos, zoomPos=$presetZoomPos"
  	}
	set info [vcc3_getFocusInfo]
	set focusSpeed [lindex $info 0]
	set focusPosition [lindex $info 1]
	puts stdout "driver: focusSpeed = $focusSpeed, focusPos = $focusPosition"
	
	set info [vcc3_getExposureInfo]
	set exposureSpeed [lindex $info 0]
	set aeRef [lindex $info 1]
	set iris [lindex $info 2]
	set shutterSpeed [lindex $info 3]
	set gain [lindex $info 4]
	puts stdout "driver: exposureSpeed=$exposureSpeed, aeRef=$aeRef, iris=$iris, shutterSpeed=$shutterSpeed, gain=$gain"
    }
}

# main function


set result [vcc3_init]

if {!$result} {
    puts stdout "Error: couldn't init camera; result is $result"
    exit
} else {
    puts stdout "Camera initialization successful"
}

InitUI

#vcc3_setPanSpeed 60
#vcc3_setTiltSpeed 60
#vcc3_setPanTiltSpeed 50 50

vwait forever

