#! /bin/sh
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian GNU/Linux
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.8  03-Mar-1998  miquels@cistron.nl
#
# This file was automatically customized by dh-make on Wed, 21 Nov 2001 22:05:04 +1100

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/gnugk
NAME=gnugk
DESC='H.323 gatekeeper'
ARGS='--config /etc/gatekeeper.ini --output /var/log/gnugk/gnugk.log --pid /var/run/gnugk/gnugk.pid'

test -f $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet \
		--chuid $NAME --pidfile /var/run/$NAME/$NAME.pid \
		--background --exec $DAEMON -- $ARGS
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
		start-stop-daemon --stop --quiet \
		--pidfile /var/run/$NAME/$NAME.pid \
		--exec $DAEMON --oknodo
	echo "$NAME."
	;;
  reload)
	echo "Reloading $DESC configuration files."
	start-stop-daemon --stop --signal 1 --quiet --pidfile \
		/var/run/$NAME/$NAME.pid --exec $DAEMON
  ;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	$0 stop && $0 start
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
