## Copyright (C) 2000 Paul Kienzle
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

## usage: idsim(u, th)

function [y, ysd] = idsim(u, th)

  if nargin!=2,
    usage("[y, ysd] = idsim(u, th)");
  endif
  if size(u,2) == size(th.b,2)
    noise=zeros(0,size(th.a,2));
  elseif size(u,2) == size(th.b,2)+size(th.a,2)
    noise=u(:,size(u,2):size(u,2)+size(th.a,2)-1);
  else
    error("idsim needs one column of u for each input of th");
  endif

  inp = zeros(size(u,1),1);
  for i=1:size(th.b,2)
    inp = inp + filter(th.b(:,i), th.f(:,i), u(:,i));
  endfor
  for i=1:size(noise,2)
    noise=filter(th.c, th.d, noise(:,i));
  endfor
  noise=noise*sqrt(th.v);
  y = zeros(size(u,1),size(th.a,2));
  for i=1:size(th.a,2)
    y(:,i) = filter(1,th.a(i), inp+noise(:,i));
  endfor

endfunction