#! /bin/sh

# octinst.sh source mpath opath xpath 

# Copies all m-files and oct-files from the source directory to the
# mpath and opath respectively.  Preserves links.  Files in
# source/data are copied to mpath.  Files in the source/bin are copied
# to xpath.

if [ $# -ne 4 ]; then
    echo 'Not enough arguments'
    exit 1
fi

# interpret input parameters
source=$1; shift
mpath=$1; shift
opath=$1; shift
xpath=$1; shift

# grab the m-files
files=`echo $source/*.m`
if [ "$files" != "$source/*.m" ] ; then
    /usr/bin/install -d $mpath
    cp -fdp $files $mpath
fi

# grab the oct-files
files=`echo $source/*.oct`
if [ "$files" != "$source/*.oct" ] ; then
    /usr/bin/install -d $opath
## Grrr... install doesn't preserve links.  Hope this works.
    cp -fdp $files $opath
fi

# grab the data files
files=`echo $source/data/*`
if [ "$files" != "$source/data/*" ] ; then
    /usr/bin/install -d $mpath
    cp -fdp $files $mpath
fi

# grab the executable files
files=`echo $source/bin/*`
if [ "$files" != "$source/bin/*" ] ; then
    /usr/bin/install -d $xpath
    cp -fdp $files $xpath
fi
