


let data n =
  let d = Gsl_matrix.create n n in
  for i=0 to pred n do
    for j=0 to pred n do
      d.{i, j} <- 1. /. (float (i+j+1))
    done
  done ;
  d

let _ = 
  let d = data 4 in
  let (eval, evec) as eigen = Gsl_eigen.symmv (`M d) in
  Gsl_eigen.symmv_sort eigen Gsl_eigen.ABS_ASC ;
  for i=0 to 3 do
    Printf.printf "eigenvalue = %g\n" eval.{i} ;
    Printf.printf "eigenvector = \n" ;
    for j=0 to 3 do
      Printf.printf "\t%g\n" evec.{j, i}
    done
  done
