/*
   Network Security MONintor
   (c)Copyright 1998-99 Tibor Koleszar
 */
#include "config.h"

/*****************************************************************************/
/*   Check the defined port and gives back TRUE if something wrong           */
/*                                                                           */
/*****************************************************************************/
int 
check_port (int port_num, char *port_name, unsigned int target)
{
  struct sockaddr_in serv_addr;
  int socket_id = 0;

  memset ((char *) &serv_addr, 0, sizeof (serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons (port_num);
  serv_addr.sin_addr.s_addr = target;

  if ((socket_id = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    {
      return 1;
    }
  if (connect (socket_id, ((struct sockaddr *) &serv_addr), sizeof (serv_addr)))
    {
      close (socket_id);
      return 1;
    }
  close (socket_id);
  return 0;
}


/*****************************************************************************/
/*    Send a mail via smtpserver to email with the data text                 */
/*                                                                           */
/*****************************************************************************/
void 
send_mail (char *email, char *smtpserver, char *data, char *subject)
{
  struct sockaddr_in serv_addr;
  struct in_addr *addr;
  int socket_id = 0;
  time_t t;
  struct hostent *hostn;
  char dummy[1024], dum[1024];

  memset ((char *) &serv_addr, 0, sizeof (serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons (25);
  serv_addr.sin_addr.s_addr = inet_addr (smtpserver);

  if (serv_addr.sin_addr.s_addr == -1)
    {
      hostn = gethostbyname (smtpserver);
      addr = (struct in_addr *) hostn->h_addr_list[0];
      if (hostn != NULL)
	serv_addr.sin_addr.s_addr = addr->s_addr;
    }

  if ((socket_id = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    {
      sprintf (dummy, "ERROR	Can't make socket while sending mail to %s", smtpserver);
      logit (dummy);
      return;
    }

  if (connect (socket_id, ((struct sockaddr *) &serv_addr), sizeof (serv_addr)))
    {
      sprintf (dummy, "ERROR	Can't connect to port 25 while sendig mail to %s", smtpserver);
      logit (dummy);
      close (socket_id);
      return;
    }

  t = time (NULL);
  read (socket_id, dum, 1024);
  sprintf (dummy, "HELO %s\n", servername);
  write (socket_id, dummy, strlen (dummy));
  read (socket_id, dummy, 512);
  sprintf (dummy, "MAIL FROM: <%s@%s>\n", username, servername);
  write (socket_id, dummy, strlen (dummy));
  read (socket_id, dummy, 512);
  sprintf (dummy, "RCPT TO: <%s>\n", email);
  write (socket_id, dummy, strlen (dummy));
  read (socket_id, dummy, 512);
  sprintf (dummy, "DATA\n");
  write (socket_id, dummy, strlen (dummy));
  read (socket_id, dummy, 512);
  sprintf (dum, ctime (&t));
  dum[strlen (dum) - 1] = 0;
  sprintf (dummy, "To: %s\nX-NsMon-Error: %s\nSubject: %s\n[%s] - %s\n.\n", email, data, subject, dum, data);
  write (socket_id, dummy, strlen (dummy));
  read (socket_id, dummy, 512);
  sprintf (dummy, "QUIT\n");
  write (socket_id, dummy, strlen (dummy));
  read (socket_id, dummy, 512);
  close (socket_id);
  return;
}

/*****************************************************************************/
/*    LOCKFILE utilities.  Make/Del/Check lockfiles                          */
/*    at all right gives back 0                                              */
/*****************************************************************************/
int 
lockfile (char *name, int option, int type, int port)
{
  FILE *lockfile;
  char lock[1024];

  // Make new lock file
  if (!type)
    {
      sprintf (lock, "%s/%s.port-%d.lock", LOCK_DIR, name, port);
    }
  else if (type == 1)
    {
      sprintf (lock, "%s/%s.ping.lock", LOCK_DIR, name);
    }
  else
    {
      sprintf (lock, "%s/%s.gateway.lock", LOCK_DIR, name);
    }

  if (option == 0)
    {
      lockfile = fopen (lock, "w");
      if (lockfile == NULL)
	{
	  fprintf (stderr, "FATAL Error while making lockfile. (errno = %d)\n", errno);
	  _exit (0);
	}
      fclose (lockfile);
    }

  // Get if lockfile is exist
  if (option == 1)
    {
      lockfile = fopen (lock, "r");
      if (lockfile == NULL)
	return 1;
      fclose (lockfile);
    }

  // Remove lockfile
  if (option == 2)
    {
      unlink (lock);
    }
  return 0;
}
