/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import bossa.util.User;
import gnu.bytecode.ArrayType;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.ObjectType;
import gnu.bytecode.ParameterizedType;
import gnu.bytecode.PrimType;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.SourceMap;
import gnu.bytecode.Type;
import gnu.bytecode.TypeVariable;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Vector;
import nice.tools.code.SpecialArray;

public class ClassType
extends ObjectType
implements AttrContainer {
    public static final int minor_version = 3;
    public static final int major_version = 45;
    int thisClassIndex;
    ClassType superClass;
    int superClassIndex = -1;
    ClassType[] interfaces;
    int[] interfaceIndexes;
    public int access_flags;
    Attribute attributes;
    public static final ClassType[] noClasses = new ClassType[0];
    public String sourcefile;
    boolean emitDebugInfo = true;
    ConstantPool constants;
    Field fields;
    int fields_count;
    Field last_field;
    int ConstantValue_name_index;
    int Code_name_index;
    int LocalVariableTable_name_index;
    int LineNumberTable_name_index;
    Method methods;
    int methods_count;
    Method last_method;
    public Method constructor;
    private static ClassType collectionType = ClassType.make("java.util.Collection");
    private String signature;
    private TypeVariable[] parameters;
    private SourceMap sourceMap;

    public static ClassType make(String name) {
        return (ClassType)Type.getType(name);
    }

    public static ClassType make(String name, ClassType superClass) {
        ClassType type = ClassType.make(name);
        if (type.superClass == null) {
            type.setSuper(superClass);
        }
        return type;
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public final ConstantPool getConstants() {
        return this.constants;
    }

    public final CpoolEntry getConstant(int i) {
        if (this.constants == null || this.constants.pool == null || i > this.constants.count) {
            return null;
        }
        return this.constants.pool[i];
    }

    public final int getModifiers() {
        if (this.access_flags == 0 && (this.flags & 4) != 0 && this.getReflectClass() != null) {
            this.access_flags = this.reflectClass.getModifiers();
        }
        return this.access_flags;
    }

    public final void setModifiers(int flags) {
        this.access_flags = flags;
    }

    public void setName(String name) {
        this.this_name = name;
        name = name.replace('.', '/');
        this.setSignature("L" + name + ";");
    }

    public void setSourceFile(String name) {
        SourceFileAttr.setSourceFile(this, name);
    }

    public void setSuper(String name) {
        this.setSuper(name == null ? Type.pointer_type : ClassType.make(name));
    }

    public void setSuper(ClassType superClass) {
        this.superClass = superClass;
    }

    public ClassType getSuperclass() {
        if (this.superClass == null && !this.isInterface() && !"java.lang.Object".equals(this.getName()) && this.getReflectClass() != null) {
            this.superClass = (ClassType)ClassType.make(this.reflectClass.getSuperclass());
        }
        return this.superClass;
    }

    public String getPackageName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    public ClassType[] getInterfaces() {
        if (this.interfaces == null && this.getReflectClass() != null) {
            Class<?>[] reflectInterfaces = this.reflectClass.getInterfaces();
            int numInterfaces = reflectInterfaces.length;
            this.interfaces = numInterfaces == 0 ? noClasses : new ClassType[numInterfaces];
            for (int i = 0; i < numInterfaces; ++i) {
                this.interfaces[i] = (ClassType)Type.make(reflectInterfaces[i]);
            }
        }
        return this.interfaces;
    }

    public void setInterfaces(ClassType[] interfaces) {
        this.interfaces = interfaces;
    }

    public void addInterface(ClassType newInterface) {
        int oldCount;
        if (this.interfaces == null || this.interfaces.length == 0) {
            oldCount = 0;
            this.interfaces = new ClassType[1];
        } else {
            int i = oldCount = this.interfaces.length;
            while (--i >= 0) {
                if (this.interfaces[i] != newInterface) continue;
                return;
            }
            ClassType[] newInterfaces = new ClassType[oldCount + 1];
            System.arraycopy(this.interfaces, 0, newInterfaces, 0, oldCount);
            this.interfaces = newInterfaces;
        }
        this.interfaces[oldCount] = newInterface;
    }

    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final void setInterface(boolean val) {
        this.access_flags = val ? (this.access_flags |= 0x200) : (this.access_flags &= 0xFFFFFDFF);
    }

    public ClassType() {
    }

    public ClassType(String class_name) {
        this.setName(class_name);
    }

    ClassType(String class_name, int flags) {
        this(class_name);
        this.flags |= flags;
    }

    public final Field getFields() {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        return this.fields;
    }

    public final int getFieldCount() {
        return this.fields_count;
    }

    public Field getDeclaredField(String name) {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        Field field = this.fields;
        while (field != null) {
            if (name.equals(field.name)) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    public Field getField(String name) {
        ClassType cl = this;
        do {
            Field field;
            if ((field = cl.getDeclaredField(name)) == null) continue;
            return field;
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public Field addField() {
        return new Field(this);
    }

    public Field addField(String name) {
        Field field = new Field(this);
        field.setName(name);
        return field;
    }

    public final Field addField(String name, Type type) {
        Field field = new Field(this);
        field.setName(name);
        field.setType(type);
        return field;
    }

    public final Field addField(String name, Type type, int flags) {
        Field field = this.addField(name, type);
        field.flags = flags;
        return field;
    }

    public void addFields() {
        java.lang.reflect.Field[] fields;
        Class clas = this.getReflectClass();
        try {
            fields = clas.getDeclaredFields();
        }
        catch (SecurityException ex) {
            fields = clas.getFields();
        }
        int count = fields.length;
        for (int i = 0; i < count; ++i) {
            int modifiers;
            java.lang.reflect.Field field = fields[i];
            if (!field.getDeclaringClass().equals(clas) || ((modifiers = field.getModifiers()) & 2) != 0) continue;
            this.addField(field.getName(), Type.make(field.getType()), modifiers);
        }
        this.flags |= 1;
    }

    public final Method getMethods() {
        return this.methods;
    }

    public final int getMethodCount() {
        return this.methods_count;
    }

    Method addMethod() {
        return new Method(this, 0);
    }

    public Method addMethod(String name) {
        Method method = new Method(this, 0);
        method.setName(name);
        return method;
    }

    public Method addMethod(String name, int flags) {
        Method method = new Method(this, flags);
        method.setName(name);
        return method;
    }

    public Method addMethod(String name, Type[] arg_types, Type return_type, int flags) {
        return this.addMethod(name, flags, arg_types, return_type);
    }

    public Method addMethod(String name, int flags, Type[] arg_types, Type return_type) {
        Method method = this.getDeclaredMethod(name, arg_types);
        if (method != null && return_type.equals(method.getReturnType()) && (flags & method.access_flags) == flags) {
            return method;
        }
        method = new Method(this, flags);
        method.setName(name);
        method.arg_types = arg_types;
        method.return_type = return_type;
        return method;
    }

    public Method addMethod(String name, String signature, int flags) {
        Method meth = this.addMethod(name, flags);
        meth.setSignature(signature);
        return meth;
    }

    public Method getDeclaredMethod(String name, Type[] arg_types, Type return_type) {
        Method method = this.getDeclaredMethod(name, arg_types);
        if (method != null && !return_type.equals(method.getReturnType())) {
            throw new Error("Method " + this.getName() + "." + name + " has two implementations with same arguments" + " but different return types " + return_type + " and " + method.getReturnType());
        }
        return method;
    }

    public Method getDeclaredMethods() {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        return this.methods;
    }

    public final int countMethods(Filter filter2, int searchSupers) {
        return this.getMethods(filter2, searchSupers, null, 0);
    }

    public Method[] getMethods(Filter filter2, boolean searchSupers) {
        return this.getMethods(filter2, searchSupers ? 1 : 0);
    }

    public Method[] getMethods(Filter filter2, int searchSupers) {
        int count = this.getMethods(filter2, searchSupers, null, 0);
        Method[] result = new Method[count];
        this.getMethods(filter2, searchSupers, result, 0);
        return result;
    }

    public int getMethods(Filter filter2, int searchSupers, Method[] result, int offset) {
        int count = 0;
        for (ClassType ctype = this; ctype != null; ctype = ctype.getSuperclass()) {
            ClassType[] interfaces;
            for (Method meth = ctype.getDeclaredMethods(); meth != null; meth = meth.getNext()) {
                if (!filter2.select(meth)) continue;
                if (result != null) {
                    result[offset + count] = meth;
                }
                ++count;
            }
            if (searchSupers == 0) break;
            if (searchSupers <= 1 || (interfaces = ctype.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                count += interfaces[i].getMethods(filter2, searchSupers, result, offset + count);
            }
        }
        return count;
    }

    public int getMethods(Filter filter2, int searchSupers, Vector result, String context) {
        int count = 0;
        for (ClassType ctype = this; ctype != null; ctype = ctype.getSuperclass()) {
            ClassType[] interfaces;
            if (context == null || (ctype.getModifiers() & 1) != 0 || context.equals(ctype.getPackageName())) {
                for (Method meth = ctype.getDeclaredMethods(); meth != null; meth = meth.getNext()) {
                    if (!filter2.select(meth)) continue;
                    if (result != null) {
                        result.addElement(meth);
                    }
                    ++count;
                }
            }
            if (searchSupers == 0) break;
            if (searchSupers <= 1 || (interfaces = ctype.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                count += interfaces[i].getMethods(filter2, searchSupers, result, context);
            }
        }
        return count;
    }

    public Method getDeclaredMethod(String name, Type[] arg_types) {
        if ((this.flags & 6) == 4) {
            try {
                this.addMethods(this.getReflectClass());
            }
            catch (NoClassDefFoundError e) {
                String className = e.getMessage();
                User.error("Could not load class: " + (className == null ? "<unknown>" : className.replace('/', '.')) + " which is required by " + this.this_name);
            }
        }
        Method method = this.methods;
        while (method != null) {
            if (name.equals(method.getName())) {
                Type[] method_args = method.getParameterTypes();
                if (arg_types == null || arg_types == method_args) {
                    return method;
                }
                int i = arg_types.length;
                if (i == method_args.length) {
                    while (--i >= 0 && (arg_types[i] == method_args[i] || arg_types[i].getSignature().equals(method_args[i].getSignature()))) {
                    }
                    if (i < 0) {
                        return method;
                    }
                }
            }
            method = method.next;
        }
        return null;
    }

    public Method getDeclaredMethod(String name, int argCount) {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        Method result = null;
        Method method = this.methods;
        while (method != null) {
            if (name.equals(method.getName()) && argCount == method.getParameterTypes().length) {
                if (result != null) {
                    throw new Error("ambiguous call to getDeclaredMethod(\"" + name + "\", " + argCount + ")\n - " + result + "\n - " + method);
                }
                result = method;
            }
            method = method.next;
        }
        return result;
    }

    public Method getMethod(String name, Type[] arg_types) {
        return this.getMethod(name, arg_types, false);
    }

    public Method getMethod(String name, Type[] arg_types, boolean concrete) {
        ClassType cl = this;
        do {
            ClassType[] interfaces;
            Method method;
            if (!((method = cl.getDeclaredMethod(name, arg_types)) == null || concrete && method.isAbstract())) {
                return method;
            }
            if (concrete || (interfaces = cl.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                method = interfaces[i].getMethod(name, arg_types);
                if (method == null) continue;
                return method;
            }
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public void addMethods() {
        if ((this.flags & 2) == 0 && this.getReflectClass() != null) {
            this.addMethods(this.getReflectClass());
        }
    }

    public void addMethods(Class clas) {
        Constructor<?>[] cmethods;
        java.lang.reflect.Method[] methods;
        this.flags |= 2;
        try {
            methods = clas.getDeclaredMethods();
        }
        catch (SecurityException ex) {
            methods = clas.getMethods();
        }
        int count = methods.length;
        for (int i = 0; i < count; ++i) {
            int modifiers;
            java.lang.reflect.Method method = methods[i];
            if (!method.getDeclaringClass().equals(clas) || ((modifiers = method.getModifiers()) & 2) != 0) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            int j = paramTypes.length;
            Type[] args = new Type[j];
            while (--j >= 0) {
                args[j] = Type.make(paramTypes[j]);
            }
            Method meth = new Method(this, modifiers);
            meth.setName(method.getName());
            meth.arg_types = args;
            meth.return_type = Type.make(method.getReturnType());
        }
        try {
            cmethods = clas.getDeclaredConstructors();
        }
        catch (SecurityException ex) {
            cmethods = clas.getConstructors();
        }
        count = cmethods.length;
        for (int i = 0; i < count; ++i) {
            int modifiers;
            Constructor<?> method = cmethods[i];
            if (!method.getDeclaringClass().equals(clas) || ((modifiers = method.getModifiers()) & 2) != 0) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            int j = paramTypes.length;
            Type[] args = new Type[j];
            while (--j >= 0) {
                args[j] = Type.make(paramTypes[j]);
            }
            Method meth = new Method(this, modifiers);
            meth.setName("<init>");
            meth.arg_types = args;
            meth.return_type = Type.void_type;
        }
    }

    public Method[] getMatchingMethods(String name, Type[] paramTypes, int flags) {
        int i = this.getMethodCount();
        int nMatches = 0;
        Vector<Method> matches = new Vector<Method>(10);
        for (Method method = this.methods; method != null; method = method.getNext()) {
            Type[] mtypes;
            if (!name.equals(method.getName()) || (flags & 8) != (method.access_flags & 8) || (flags & 1) > (method.access_flags & 1) || (mtypes = method.arg_types).length != paramTypes.length) continue;
            ++nMatches;
            matches.addElement(method);
        }
        Object[] result = new Method[nMatches];
        matches.copyInto(result);
        return result;
    }

    Method refineMethod(Method method) {
        Method res = this.getMethod(method.getName(), method.arg_types);
        if (res == method) {
            return null;
        }
        return res;
    }

    public void doFixups() {
        if (this.constants == null) {
            this.constants = new ConstantPool();
        }
        if (this.thisClassIndex == 0) {
            this.thisClassIndex = this.constants.addClass((ObjectType)this).index;
        }
        if (this.superClass == this) {
            this.setSuper((ClassType)null);
        }
        if (this.superClassIndex < 0) {
            int n = this.superClassIndex = this.superClass == null ? 0 : this.constants.addClass((ObjectType)this.superClass).index;
        }
        if (this.interfaces != null && this.interfaceIndexes == null) {
            int n = this.interfaces.length;
            this.interfaceIndexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.interfaceIndexes[i] = this.constants.addClass((ObjectType)this.interfaces[i]).index;
            }
        }
        Field field = this.fields;
        while (field != null) {
            field.assign_constants(this);
            field = field.next;
        }
        Method method = this.methods;
        while (method != null) {
            method.assignConstants();
            method = method.next;
        }
        Attribute.assignConstants(this, this);
    }

    public void writeToStream(OutputStream stream) throws IOException {
        DataOutputStream dstr = new DataOutputStream(stream);
        this.doFixups();
        dstr.writeInt(-889275714);
        dstr.writeShort(3);
        dstr.writeShort(45);
        if (this.constants == null) {
            dstr.writeShort(1);
        } else {
            this.constants.write(dstr);
        }
        dstr.writeShort(this.access_flags);
        dstr.writeShort(this.thisClassIndex);
        dstr.writeShort(this.superClassIndex);
        if (this.interfaceIndexes == null) {
            dstr.writeShort(0);
        } else {
            int interfaces_count = this.interfaceIndexes.length;
            dstr.writeShort(interfaces_count);
            for (int i = 0; i < interfaces_count; ++i) {
                dstr.writeShort(this.interfaceIndexes[i]);
            }
        }
        dstr.writeShort(this.fields_count);
        Field field = this.fields;
        while (field != null) {
            field.write(dstr, this);
            field = field.next;
        }
        dstr.writeShort(this.methods_count);
        Method method = this.methods;
        while (method != null) {
            method.write(dstr, this);
            method = method.next;
        }
        Attribute.writeAll(this, dstr);
        this.flags |= 3;
    }

    public void writeToFile(String filename) throws IOException {
        this.writeToFile(new File(filename));
    }

    public void writeToFile(File file) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        this.writeToStream(stream);
        ((OutputStream)stream).close();
    }

    public void writeToFile() throws IOException {
        this.writeToFile(this.this_name.replace('.', File.separatorChar) + ".class");
    }

    public byte[] writeToArray() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(500);
        this.writeToStream(stream);
        return stream.toByteArray();
    }

    public static byte[] to_utf8(String str) {
        if (str == null) {
            return null;
        }
        int str_len = str.length();
        int utf_len = 0;
        for (int i = 0; i < str_len; ++i) {
            char c = str.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                ++utf_len;
                continue;
            }
            if (c <= '\u07ff') {
                utf_len += 2;
                continue;
            }
            utf_len += 3;
        }
        byte[] buffer = new byte[utf_len];
        int j = 0;
        for (int i = 0; i < str_len; ++i) {
            char c = str.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                buffer[j++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                buffer[j++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[j++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            buffer[j++] = (byte)(0xE0 | c >> 12 & 0xF);
            buffer[j++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[j++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return buffer;
    }

    public final boolean implementsInterface(ClassType iface) {
        if (this == iface) {
            return true;
        }
        ClassType baseClass = this.getSuperclass();
        if (baseClass != null && baseClass.implementsInterface(iface)) {
            return true;
        }
        ClassType[] interfaces = this.getInterfaces();
        if (interfaces != null) {
            int i = interfaces.length;
            while (--i >= 0) {
                if (!interfaces[i].implementsInterface(iface)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isSubclass(ClassType other) {
        if (this == tostring_type && other == string_type || this == string_type && other == tostring_type) {
            return true;
        }
        ClassType baseClass = this;
        do {
            if (baseClass == other) {
                return true;
            }
            ClassType[] itfs = baseClass.getInterfaces();
            if (itfs == null) continue;
            for (int i = 0; i < itfs.length; ++i) {
                if (!itfs[i].implementsInterface(other)) continue;
                return true;
            }
        } while ((baseClass = baseClass.getSuperclass()) != null);
        return false;
    }

    public int compare(Type other) {
        if (this == other) {
            return 0;
        }
        if (other instanceof PrimType) {
            return ClassType.swappedCompareResult(((PrimType)other).compare(this));
        }
        if (other == pointer_type) {
            return -1;
        }
        if (this == pointer_type || other == nullType) {
            return 1;
        }
        if (other instanceof ArrayType) {
            return ClassType.swappedCompareResult(((ArrayType)other).compare(this));
        }
        if (!(other instanceof ClassType)) {
            return -3;
        }
        String name = this.getName();
        if (name != null && name.equals(other.getName())) {
            return 0;
        }
        ClassType cother = (ClassType)other;
        if (this.isInterface()) {
            if (cother.implementsInterface(this)) {
                return 1;
            }
            if (cother.isInterface() && this.implementsInterface(cother)) {
                return -1;
            }
            return -2;
        }
        if (cother.isInterface()) {
            if (this.implementsInterface(cother)) {
                return -1;
            }
            return -2;
        }
        if (this.isSubclass(cother)) {
            return -1;
        }
        if (cother.isSubclass(this)) {
            return 1;
        }
        if (this == tostring_type) {
            return 1;
        }
        if (cother == tostring_type) {
            return -1;
        }
        if (this.isInterface() || cother.isInterface()) {
            return -2;
        }
        return -3;
    }

    public boolean isAssignableTo(Type other) {
        if (!(other instanceof ClassType)) {
            return false;
        }
        return other.compare(this) >= 0;
    }

    public void emitCoerceFromObject(CodeAttr code) {
        if (this == collectionType) {
            code.emitDup();
            code.emitInstanceof(this);
            code.emitIfIntNotZero();
            code.emitCheckcast(this);
            code.emitElse();
            SpecialArray.unknownTypeArray().emitCoerceToObject(code);
            code.emitFi();
            code.popType();
            code.pushType(collectionType);
        } else {
            super.emitCoerceFromObject(code);
        }
    }

    public String toString() {
        return "ClassType " + this.getName();
    }

    private void loadSignature() {
        Attribute sig = Attribute.get(this, "Signature");
        if (!(sig instanceof MiscAttr)) {
            this.signature = "";
            return;
        }
        MiscAttr s = (MiscAttr)sig;
        int index = s.data[1] & 0xFF | (s.data[0] & 0xFF) << 8;
        this.signature = ((CpoolUtf8)this.constants.getPoolEntry(index)).getString();
        if (this.signature.charAt(0) != '<') {
            this.parameters = TypeVariable.none;
            return;
        }
        int[] pos = new int[]{0};
        this.parameters = TypeVariable.parse(this.signature, pos);
    }

    public int getArity() {
        if (this.signature == null) {
            this.loadSignature();
        }
        if (this.signature == "") {
            return -1;
        }
        return this.parameters.length;
    }

    public TypeVariable[] getParameters() {
        if (this.signature == null) {
            this.loadSignature();
        }
        if (this.signature == "") {
            return null;
        }
        return this.parameters;
    }

    public Type thisType() {
        if (this.signature == null) {
            this.loadSignature();
        }
        if (this.parameters == null) {
            return this;
        }
        return new ParameterizedType(this, this.parameters);
    }

    SourceMap getSourceMap() {
        if (this.sourceMap == null) {
            this.sourceMap = new SourceMap(this);
            this.sourceMap.addToFrontOf(this);
        }
        return this.sourceMap;
    }
}

