/*  VER 114  TAB P   $Id: server.c,v 1.15.2.4 2002/10/02 09:05:28 egil Exp $
 *
 *  NNTP server interface
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: server.c,v $
 *  Revision 1.15.2.4  2002/10/02 09:05:28  egil
 *  Do not flush stream when posting
 *
 *  Revision 1.15.2.3  2002/10/01 08:54:59  egil
 *  Changed sprintf to snprintf
 *
 *  Revision 1.15.2.2  2002/09/21 17:20:36  egil
 *  A long range of patches incorporated..
 *
 *  Revision 1.15.2.1  2002/02/06 20:38:19  egil
 *
 *  Debian Bug#26209:
 *  Really done earlier...
 *
 *  Revision 1.15  1999/03/31 03:38:29  src
 *  Moved errno.h to common.h
 *
 *  Revision 1.14  1999/03/15 08:51:36  src
 *  Nothing.
 *
 *  Revision 1.13  1999/03/11 07:30:01  src
 *  Implemented check for spool free space
 *
 *  Revision 1.12  1998/11/21 19:14:24  src
 *  Added --filter option
 *
 *  Revision 1.11  1998/09/09 07:32:13  src
 *  Version 1.1
 *
 *  Revision 1.10  1998/09/03 02:19:39  src
 *  Fixed noaction error exit
 *
 *  Revision 1.9  1998/09/02 06:50:31  src
 *  newsx version 1.0
 *
 *  Revision 1.8  1998/09/02 06:34:41  src
 *  Support @-syntax in newsfeeds, and support AUTHINFO GENERIC
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "statistics.h"
#include "nntp.h"

/*
 *  currently open socket pair, for read and write
 */
SOCKET_D nntp_sock;

/*
 *  trivial function: let people get at the socket if they need to.
 *  This is used in AUTHINFO GENERIC: we handle authentication via
 *  a child process, which needs the file descriptors of the socket
 *  so it can talk to the server.       -- PMM 08/1998
 */
SOCKET_D *current_socket(void)
{
    return &nntp_sock;
}

/*
 *  open an NNTP server connection
 *  returns servers initial response code  
 *  if it is -1, try to give up as soon as possible
 */
int 
open_server(char *host,char *port)
{
    int sts;
    char line[NNTP_STRLEN];
    char *endptr;

    /* first try and make the connection */
    if (via_exec) {
	progtitle("connecting pgm");

	program_open(via_exec, &nntp_sock);
    } else {
	progtitle("connecting");

	if ((socket_open(host, port, &nntp_sock)) < 0)
	    return -1;
	log_msg(L_INFO,"connecting to %s server at %s", port, host);
    }

    if (connect_exec) {
	/* execute command when initiating */
	progtitle("exec cmd");
						
	log_msg(L_DEBUGMORE,"running \"%s\"", connect_exec);
	fflush(nntp_sock.w_str);                       
	if ((sts = script(connect_exec,
		       /* in */  fileno(nntp_sock.r_str),
		       /* out */ fileno(nntp_sock.w_str))) != 0) {
	    /* connect failed */
	    log_msg(L_ERR,"connect script failed, status is %d",sts);
	    exit_cleanup(11);
	}
	log_msg(L_DEBUG,"connect script finished");
    }

    progtitle("await greeting");
    /* flush possible garbage */
    do {
	/* greeting */
	if (!get_server_nntp(line,sizeof(line))) {
	    /* timeout */
	    exit_cleanup(9);
	}
	
    } while (!isdigit(line[0]));

    /* banner code */
    return strtoul(line,&endptr,10); 
}

/*
 *  close NNTP connection
 *  false if server timeout etc.
 */
int
close_server(int urgent)
{
    char line[NNTP_STRLEN];

    if (urgent) {
	progtitle("aborting server");
	timeout = URGENT_TIMEOUT;
    } else {
	progtitle("closing server");
    }
    if (!put_server_cmd("QUIT")) return 0;
    if (!get_server_nntp(line,sizeof(line))) return 0;

    socket_close(&nntp_sock);
    return 1;
}

/*
 *  read a line from server
 *  flush out request queue first
 *  return 0 on timeout and other severe problems
 */
int get_server_nntp(char *line, int size)
{
    /* since this request is not windowed, we must flush any request queue */
    if (!flush_request()) return -1;

    return get_server_nntp_nf(line, size);
}

/*
 *  read a line from server, with no regard to request queue
 *  return 0 on timeout and other severe problems
 */
int get_server_nntp_nf(char *line, int size)
{
    int len;

    if (noaction_opt) {
	line[0] = '\0';
	return 1;
    }
    if (!get_socket(line, size, &nntp_sock)) {
	return 0;
    }
    len = strlen(line);
    gross_bytecount += len;
    log_msg(L_GET,"%s", line);

    /* no CRLF */
    while (len > 0 && (line[len-1]=='\r' || line[len-1]=='\n')) {
	line[--len] = '\0';
    }

    return 1;
}

/*
 *  read message part from server
 *  any CRLF will not be removed
 *  do not keep gross_bytecount up to date
 *  return 0 on timeout and other severe problems
 */
int 
get_server_msg(char *line, int size)
{
    if (noaction_opt) {
	line[0] = '\0';
	return 1;
    }
    if (!get_socket(line, size, &nntp_sock)) {
	return 0;
    }
    if (debug_opt >= 7) {
	log_msg(L_GET,"%s", line);
    }
    return 1;
}

/*
 *  write an NNTP command line to server
 *  with no debug log
 *  append a newline
 */
int
put_server_nolog(char *line)
{
    int len;
    if (noaction_opt) return 1;

    len = strlen(line);
    gross_bytecount += len + len_newline;
    return put_socket_line(line, len, &nntp_sock, 1);
}

/*
 *  write an NNTP command line to server
 *  a newline will be added
 *  return nonzero if problems
 */
int
put_server_cmd(char *line)
{
    log_msg(L_PUT,"%s\n", line);

    return put_server_nolog(line);
}

/*
 *  write message part to server, 
 *  a newline will be added
 *  if do_flush set, then flush socket too
 *  return 0 on timeout and other problems
 */
int 
put_server_line(char *line, int len, int do_flush)
{
    if (debug_opt >= 7) {
	log_msg(L_PUT,"%.*s\n",len,line);
    }
    if (noaction_opt) return 1;

    gross_bytecount += len + len_newline;
    return put_socket_line(line, len, &nntp_sock, do_flush);
}
