(* $Id: http_client_aux.ml 126 2004-05-25 20:56:41Z gerd $
 * ----------------------------------------------------------------------
 * Auxiliary functions: this version uses Str and is not thread-safe.
 *)

open Str

let query_re = regexp "^http://\\([^/:]+\\)\\(:\\([0-9]+\\)\\)?\\(/[^ ]*\\)?$"
let status_re = regexp "^\\([^ \t]+\\)[ \t]+\\([0-9][0-9][0-9]\\)\\([ \t]+\\([^\r\n]*\\)\\)?\r?"
let line_re = regexp "^\\([^ \t:]+\\)[ \t]*:[ \t]*\\(.*\\)$"
let hex_re = regexp "^\\([0-9A-Fa-f]+\\)"
let ip_re = regexp "^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$"
let http_re =
  regexp
    "http://\\(\\([^/:@]+\\)\\(:\\([^/:@]+\\)\\)?@\\)?\\([^/:@]+\\)\\(:\\([0-9]+\\)\\)?\\(/.*\\)?"
let comma_re = regexp "[ \t\n\r]*,[ \t\n\r]*"




let match_query query =
  if string_match query_re query 0 then begin
    let host = String.lowercase (matched_group 1 query) in
    let port = 
      try int_of_string (matched_group 3 query)
      with Not_found -> 80 in
    let path = 
      try matched_group 4 query 
      with Not_found -> ""
    in
    host, port, path
  end
  else raise Not_found
;;


let match_status status_line =
  if string_match status_re status_line 0 then begin
    matched_group 1 status_line,
    int_of_string (matched_group 2 status_line),
    ( try matched_group 4 status_line with Not_found -> "" )
  end
  else raise Not_found
;;


let match_header_line line =
  if string_match line_re line 0 then
    String.lowercase(matched_group 1 line), matched_group 2 line
  else
    raise Not_found
;;


let match_hex hex =
  if string_match hex_re hex 0 then
    matched_group 1 hex
  else
    raise Not_found
;;


let match_ip ip =
  if string_match ip_re ip 0 then
    ip
  else
    raise Not_found
;;


let match_http url =
  if string_match http_re url 0 then begin
    let user =
      try Some(matched_group 2 url) with Not_found -> None in
    let password =
      try Some(matched_group 4 url) with Not_found -> None in
    let host =
      matched_group 5 url in
    let port =
      try int_of_string(matched_group 7 url) with Not_found -> 80 in
    let path =
      try matched_group 8 url with Not_found -> "" in
    user, password, host, port, path
  end
  else raise Not_found
;;


let split_words_by_commas s =
  split comma_re s
;;


module Mtx = 
  (* A dummy implementation *)
  struct
    type t = unit
    let create () = ()
    let lock () = ()
    let try_lock () = true
    let unlock() = ()
  end
;;


