/* Copyright (C) 2000-2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef MYODBCDATASOURCEDIALOG_H
#define MYODBCDATASOURCEDIALOG_H

#include <qobject.h>
#include <qtabdialog.h>
#include <qstring.h>
#include <qfileinfo.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qdatetime.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qprocess.h>
#include <qmessagebox.h>
#include <qtooltip.h>

#include "MYODBCSetup.h"

class MYODBCSetupDataSourceDialog : public QTabDialog
{
    Q_OBJECT

public:
    MYODBCSetupDataSourceDialog( QWidget *pwidgetParent, WORD nRequest, LPCSTR pszDriver, MYODBC_NAMEVALUE **aNameValues );
    MYODBCSetupDataSourceDialog( QWidget *pwidgetParent, WORD nRequest, LPCSTR pszDriver, LPCSTR pszDataSourceName );

    BOOL bDone;

public slots:
    void slotHelp();
    void slotApply();
    void slotTest();

protected:
    WORD                nRequest;
    LPCSTR              pszDriver; 
    LPCSTR              pszDataSourceName; 
    MYODBC_NAMEVALUE ** aNameValues;
    int                 nDataSourceName;
    int                 nDescription;
    int                 nServer;
    int                 nUser;
    int                 nPassword;
    int                 nDatabase;
    int                 nPort;
    int                 nStmt;
    int                 nSocket;
    int                 nOption;

    // Tab 1
    QLabel *    plabelSideImage;
    QLineEdit * plineeditDataSourceName;
    QLineEdit * plineeditDescription;
    QLineEdit * plineeditServer;
    QLineEdit * plineeditUser;
    QLineEdit * plineeditPassword;
    QComboBox * pcomboboxDatabase;
    QLineEdit * plineeditPort;
    QLineEdit * plineeditStmt;
    QLineEdit * plineeditSocket;
    QLineEdit * plineeditOptions;
    QPushButton *ppushbuttonTest;

    void doInit();
    void doInitTab1();

    void doSetValuesFromSystemInfo();
    void doSetValuesFromGivenAttributes();

    void doShowDiagnostics( SQLRETURN nReturn, SQLSMALLINT nHandleType, SQLHANDLE h );
    void doShowInstallerError();
};

#endif
