/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 preferences.h  -  Application preferences and associated classes.
 
 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)                             
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__PREFERENCES_H_INCLUDED__)
#define __PREFERENCES_H_INCLUDED__

class MController;
class MPropertyContainer;

#define MAX_PATH 1024
#define MAX_URL 256

class MGnuPreferences  
{
friend class MController;
public:
	MGnuPreferences(MController*);
	virtual ~MGnuPreferences();

	CString GetDefaultDir();

	// Mutex, shared by sets
	MMutex m_mutex;

	// Local
	IP    m_ipLocalHost;		  // IP of node
	IP    m_ipForcedHost;		  // IP of node assigned by user
	char  m_szDynDnsFirewall[MAX_URL]; // IP of node should be set from the DNS request
	bool  m_bAcceptRemoteIpHeader; // when we connect to gnutella some clients send us oir IP
	DWORD m_dwLocalPort;		  // Port of node	
	DWORD m_dwForcedPort;		  // Port of node assigned by user
	DWORD m_dwSpeedStat;		  // Node speed determined by the user
	DWORD m_dwSpeedDyn;		      // Node speed determined by gnucleus
	int   m_nSaveStatePeriod;	  // auto save state period

	// Local Firewall
	bool  m_bBehindFirewall;
	bool  m_bReachableForPush;
	
	// Connect
	bool    m_bQuietMode;
	int     m_nMinConnects;
	int     m_nMaxConnects;
	int     m_nMaxIncomingConns;
	int     m_nMaxConnPerSubnetA;	// Max connections per class-A subnet
	int     m_nMaxConnPerSubnetB;	// Max connections per class-B subnet
	int     m_nMaxConnPerSubnetC;	// Max connections per class-C subnet
	int     m_nLeafModeConnects;
	bool    m_bEnableSuperNodeMode;
	bool    m_bForceSuperNodeMode;
	int     m_nMaxLeaves;

	// Connect Servers
	char m_szGWebCache1[MAX_URL];
	char m_szGWebCache2[MAX_URL];
	char m_szGWebCache3[MAX_URL];
	bool m_bGWebCacheFollowRedirect;

	// various filters and blacklists
	bool m_bBlackListActive;
	TPropertySet<IPNET> m_ipnetsetBlackList;
	bool m_bWordFilterActive;
	TPropertySet<CString> m_setWordFilter;
	TPropertySet<IPNET> m_ipnetsetWhiteList;
	
	// Timeouts
	DWORD m_dwConnectTimeout;
	DWORD m_dwPushTimeout;
	DWORD m_dwSpeedTimeout;
	DWORD m_dwTransferTimeout;

	// Search
	char    m_szDownloadPath[MAX_PATH];
	bool    m_bStrictSearch;
	int     m_nMinFileKSize;
	int     m_nMaxFileKSize;
	int     m_nResubmitSearches;
	int     m_nMaxSearches;
	int     m_nMaxPerSearchResults;
	bool    m_bSaveSearches;
	//int     m_nMaxResultsDisplayed;
	bool    m_bStrictSha1Grouping;

	// Share
	char m_szSharePath[MAX_PATH];
	char m_szShareFilter[MAX_PATH];
	bool m_bReplyFilePath;
	int  m_nMaxReplies;
	bool m_bSendOnlyAvail;
	bool m_bShareDownloadDir;
	bool m_bShareDotFiles;

	// Transfer
	int   m_nMaxDownloads;
	int   m_nMaxUploads;
	int	  m_nRetryWait;
	int   m_nMaxPerHostDownloads;
	int   m_nMaxPerHostUploads;
	int   m_nMaxPerFileUploads;

	// Bandwidth
	double m_dBandwidthTotal;
	double m_dBandwidthTransfer;
	double m_dBandwidthConnects;
	double m_dBandwidthDownl;
	double m_dMinDownSpeed;
	double m_dMinUpSpeed;

protected:
	MGnuPreferences();                          // no implementation
	MGnuPreferences(const MGnuPreferences& rSrc);  // no implementation
		
protected:
	MController* m_pController;
	MPropertyContainer* m_pContainer;
};

#endif // __PREFERENCES_H_INCLUDED__

