//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: mitplugin.h,v 1.1.1.1 2003/10/29 10:06:16 wschweer Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MITPLUGIN_H__
#define __MITPLUGIN_H__

#include <list>

class MidiPlayEvent;
class Xml;

//---------------------------------------------------------
//   MITPlugin
//    midi input transform plugin
//---------------------------------------------------------

class MITPlugin {
   public:
      virtual void process(MidiPlayEvent* event) = 0;
      virtual void readStatus(Xml&) {}
      virtual void writeStatus(int, Xml&) const {}
      };

typedef std::list<MITPlugin*> MITPluginList;
typedef MITPluginList::iterator iMITPlugin;

extern MITPluginList mitPlugins;
extern void processMidiInputTransformPlugins(MidiPlayEvent*);
extern void writeStatusMidiInputTransformPlugins(int, Xml&);
extern void readStatusMidiInputTransformPlugin(Xml&);

#endif

