#include <stdio.h>
#include <MRI.h>
#include "ToneCurveLoader.h"

int
main (int argc, char *argv[])
{
	double minidx[512], minval[512];
	double fixidx[512], fixval[512];
	double sample[512];
	MRI_SampledCurve *crv;
	double w, total;
	int i, n;
	if (argc != 2) {
		fprintf (stderr, "Usage: %s tone.dat\n", argv[0]);
		exit (1);
	}
	if (LoadToneFile (DATAPREFIX"/tonecurves/standard.tc", minidx, minval, 512) != 512) {
		fprintf (stderr, "%s: standard.tc has unexpected size\n", argv[0]);
		exit (1);
	}
	crv = LoadSampledToneCurve (argv[1]);
	/* Compute and output the "Bryan Bigger's correction factor". */
	printf ("0,0\n");
	total = w = 0.0;
	for (i = 1; i < 512; i++) {
		double v = MRI_SampleCurveMapValue (crv, i/511.0);
		total += v - w -1.0/511.0;
		w = v;
		printf ("%f,%f\n", minidx[i]*511.0, (total + minval[i])*511.0);
	}
	exit (0);
}
