#include <stdio.h>
#include <stdlib.h>
#include "lcms.h"
#include "MRW_Private.h"

unsigned char data[2*1024*1024];

int
LoadMinoltaJPG (FILE *f, MinoltaJPG *hdr)
{
    int count;
    int exif_offset;
    int pim_offset;
    int manu_offset;
    int tmbOffset;
    int settings_offset;

    read (0, hdr->header, sizeof(hdr->header));
    hdr->data_length = count = read (0, data, sizeof(data));
    hdr->data = malloc (count);
    memcpy (hdr->data, data, count);

    hdr->mrw_ifd = ParseIFD (hdr->data, 8);
    exif_offset = IFD_GetLong (hdr->mrw_ifd, IFDTAG_EXIFOFFSET);
    hdr->exif_ifd = ParseIFD (hdr->data, exif_offset);

    pim_offset = IFD_GetUndefined (hdr->mrw_ifd, IFDTAG_PIMOFFSET);
#ifdef DEBUG
    fprintf (stderr, "PIM_OFFSET = %d\n", pim_offset);
#endif
    if (pim_offset == 0)
	hdr->pim = NULL;
    else
	hdr->pim = hdr->data + pim_offset;

    manu_offset = IFD_GetUndefined (hdr->exif_ifd, EXIFTAG_MANUFNOTES);
#ifdef DEBUG
    fprintf (stderr, "MANU_OFFSET = %d\n", manu_offset);
#endif

    hdr->manu_ifd = ParseIFD (hdr->data, manu_offset);
    if (hdr->manu_ifd == (IFD *)0) {
	fprintf (stderr, "LoadMRW: Unable to read Manufacturer directory\n");
	return 0;
    }
    tmbOffset = IFD_GetUndefined (hdr->manu_ifd, MANUTAG_THUMBNAIL);
    hdr->thumbnail = hdr->data + tmbOffset;
    hdr->thumbnail_length = IFD_GetUndefinedLength (hdr->manu_ifd, MANUTAG_THUMBNAIL);
    fprintf (stderr, "Thumbnail offset+length=%d\n", tmbOffset + hdr->thumbnail_length);

    settings_offset = IFD_GetUndefined (hdr->manu_ifd, MANUTAG_CAMERASETTINGS);
#ifdef DEBUG
    fprintf (stderr, "SETTINGS_OFFSET = %d\n", settings_offset);
#endif
    if (settings_offset == 0) {
#ifdef DEBUG
	    fprintf (stderr, "Trying tag 0x0003\n");
#endif
	    settings_offset = IFD_GetUndefined (hdr->manu_ifd, MANUTAG_CAMERASETTINGS2);
#ifdef DEBUG
	    fprintf (stderr, "SETTINGS_OFFSET = %d\n", settings_offset);
#endif
    }
    if (settings_offset == 0) {
	    fprintf (stderr, "LoadMRW: Unable to find camera settings info\n");
	    return 0;
    }
    hdr->settings = hdr->data + settings_offset;
    hdr->settings_length = IFD_GetUndefinedLength (hdr->manu_ifd, MANUTAG_CAMERASETTINGS);
    if (hdr->settings_length == 0)
	    hdr->settings_length = IFD_GetUndefinedLength (hdr->manu_ifd, MANUTAG_CAMERASETTINGS2);

    return 1;
}
