/* Tone Curve Table for Minolta Raw Photo Plugin
 *
 * Copyright (C) 2004 Bradley Broom
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>

#include "../../config.h"

#include <glib/gthread.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "lcms.h"

#include <MRI.h>
#include <MRW_Loader.h>
#include "../FindFile.h"
#include "../options.h"

#include "mrwplugin-intl.h"
#include "tonecurves.h"

struct toneCurveTable_t {
    gchar *baseName;
    gchar *intlName;
    gchar *shortName;
} toneCurveTable[] = {
   { N_("None"), NULL, "none", },
   { N_("Standard"), NULL, "standard", },
   { N_("Bryan's Best"), NULL, "bryansbest", },
   { N_("Bryan's Original"), NULL, "biggers", },
   { N_("Bryan's Aggressive"), NULL, "aggressive", },
   { N_("Bryan's Subdued"), NULL, "subdued", },
};

gint
num_tone_curves()
{
    return sizeof(toneCurveTable)/sizeof(toneCurveTable[0]);
}

gchar *
get_tone_curve_shortname (gint index)
{
  if (index >= 0 && index < sizeof(toneCurveTable)/sizeof(toneCurveTable[0]))
      return toneCurveTable[index].shortName;
  else
      return "unknown";
}

gchar *
get_tone_curve_intlname (gint index)
{
    if (index >= 0 && index < sizeof(toneCurveTable)/sizeof(toneCurveTable[0])) {
        if (toneCurveTable[index].intlName == NULL)
            toneCurveTable[index].intlName = _(toneCurveTable[index].baseName);
	return toneCurveTable[index].intlName;
    }
    else
        return "internal error";
}

gpointer
get_tone_curve_handle (gint index)
{
    if (index >= 0 && index < sizeof(toneCurveTable)/sizeof(toneCurveTable[0]))
        return (gpointer)&toneCurveTable[index];
    else
        return NULL;
}

gint
get_tone_curve_index (gpointer handle)
{
    return handle == NULL ? -1 : (struct toneCurveTable_t *)handle - toneCurveTable;
}

gint
find_tone_curve (gchar *shortName)
{
    gint i;

    for (i = 0; i < sizeof(toneCurveTable)/sizeof(toneCurveTable[0]); i++)
        if (strcmp (toneCurveTable[i].shortName, shortName) == 0)
            return i;
    return -1;
}
