/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <unistd.h>
#include <string.h>

#include "FindFile.h"

char * 
FindFile (const char *name, const char *pathList, const char *ext)
{
        char buffer[1024];
	const char *s;
	char *p;

	s = pathList;
	while (*s) {
		p = buffer;
		while (*s && *s != ':') *p++ = *s++;
		if (*s == ':') s++;
		if (p == buffer) *p++ = '.';
		*p++ = '/';
		strcpy (p, name);
		if (ext) strcat (p, ext);
		if (access (buffer, R_OK) == 0)
		       return strdup (buffer);
	}
	return NULL;
}
