/* 
 *   Creation Date: <1999/02/27 22:24:26 samuel>
 *   Time-stamp: <1999/03/04 03:46:39 samuel>
 *   
 *	<platinum_hw.h>
 *	
 *	Platinum hardware (videocontroller in the 7200/8200)
 *   
 *   Copyright (C) 1999 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_PLATINUM_HW
#define _H_PLATINUM_HW

#include <sys/types.h>

/*
 * Structure of the registers for the DACula colormap device.
 */
#define DAC_REG_SIZE	0x10
#define DAC_SIZE     	0x40
enum { 
	dacr_addr=0, 
	dacr_d1, 
	dacr_d2, 
	dacr_lut 
};

#define PLATINUM_REG_SIZE	0x10
#define PLATINUM_SIZE		0x800

typedef struct cmap_regs {
        unsigned char 	addr;
        char pad1[15];
        unsigned char 	d1;
        char pad2[15];
        unsigned char 	d2;
        char pad3[15];
        unsigned char 	lut;
        char pad4[15];
} ph_cmap_regs_t;

typedef struct {   /* Big endian registers */
        ulong 		r;
        char pad[12];
} ph_preg_t;

typedef struct {
        ph_preg_t 	reg[128];
} ph_platinum_regs_t;


/*
 * Description of (a very few) platinum registers:
 *	HEX:	R=Read / W=Write & Read / *=Read before write
 *
 * The first 15 registers are probably not related to video (or?)
 *
 * 	0 	(R)	30018140    Platinum chip identifier (some of the bits)
 *	2	(R)	
 *	3	(R)
 *	4	(W) 	40		
 *	5	(W)	
 *	6-14	(*W)
 *	15	??
 *
 * Video mode registers
 *
 *	16:   	frame_buffer_phys +0x1000 - 0x10
 *	17:	???
 *	18:	init->pitch[cmode]
 *	19:	= 1MB VRAM:	init->mode[cmode+1]
 *		> 1MB		init->mode[cmode]
 *	20:	= 1MB VRAM:	0x0011
 *		> 1MB		0x1011
 *	21:	*0x100
 *	22:	1
 *	23:	Sense [xxxABC]	   00110111
 *			7	-> turn off drivers
 * 			3	-> drive A low (B,C can be readed )
 *			5	-> drive B low (A,C can be readed )
 *			6	-> drive C low (A,B can be readed )
 *		1 (normal operation)
 *
 *	24:	0	display on
 *		7	display off
 *	25:	???
 *	26:	0xc00
 *	27:	*0x235	(0x2aa)
 *	28-31:	???
 *	34:	interrupt enable register (?)
 *	35:	interrupt flag register
 *	32-57: 	videomode registers
 *	58:	  1MB VRAM:     init->offset[cmode] + 4 - cmode	
 *		> 1MB:	  	init->offset[cmode]
 * Not video registers (?):
 *
 *	75:     *W
 */

/* DAC hardware info:
 *	
 *  "Used" addresses for D2:
 *	0x10		Could be Mouse X
 *	0x11		Could be Mouse Y
 *	0x20		1MB VRAM:  dacula_ctrl[cmode] & 0xff 
 *			>1MB	   dacula_ctrl[cmode]
 *	0x21		4
 *	0x22		0
 *	0x23		2,3 (3==clockparams in 0x27,0x28, 2==clockp. in 0x24,0x25)
 *	0x24,0x25	clockparams
 *	0x26		0xc6
 *	0x27,0x28  	clockparams
 *	0x29		0xa6
 *	0x40		0x3c = clktype1, 0x84 = clktype0 
 *	
 *  "Used" addresses for D1:
 *	0x0	(write, 24 bytes)
 * 
 */

#endif   /* _H_PLATINUM_HW */

