///////////////////////////////////////////////////////////////////////////////
// $Id: mainwindow.h,v 1.7 2004/06/30 23:40:48 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    mainwindow.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the main window class
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

// Qt includes
#include <qptrlist.h>

// local includes
#include "mainwindowbase.h"

// forward declarations
class Editor;
class QSettings;

class MainWindow : public MainWindowBase
{
	Q_OBJECT
public:
	MainWindow(QWidget* parent=0, const char* name=0);
	~MainWindow();

	QString mapDirectory() const;

	QString tilesDirectory() const;

public slots:
	void slotNew();
	void slotOpen();
	void slotClose();
	void slotSave();
	void slotSaveAs();

	void slotSelectAll();
	void slotResize();

	void slotCut();
	void slotCopy();
	void slotPaste();

	void slotShowGrid(bool show);

protected:
	void closeEvent(QCloseEvent* event);

private:
	QString tabCaption(const QString& filename);
	void readSettings();
	void writeSettings();
	bool queryClose();

private slots:
	void slotBrowseMapDirectory();
	void slotBrowseTilesDirectory();

	void slotTabChanged();

private:
	static const QString BASE_CAPTION;
	QSettings* m_settings;

	QPtrList<Editor> m_editors;
};

#endif

// End of file
