/*======================================================================*\
|*		Editor mined						*|
|*		MSDOS mouse functions					*|
|*		currently included from io.c				*|
\*======================================================================*/

#ifdef __TURBOC__
#undef dpmi_call
#endif

#ifdef dpmi_call
#include <dpmi.h>
#endif

extern void mouseinit _((void));
extern void hidemouse _((void));
extern void mousestat _((void));
extern int mousegetch _((void));
extern void DIRECTdosmousegetxy _((void));


/*======================================================================*\
|*		mouse functions and data				*|
\*======================================================================*/

#ifdef dpmi_call
__dpmi_regs mregs;
#else
union REGS mregs;
#endif


static
void
mousecall ()
{
	mregs.x.bx = 0;
#ifdef dpmi_call
	__dpmi_int (0x33, & mregs);
#else
	int86 (0x33, & mregs, & mregs);
#endif
}

void
mouseinit ()
{
	mregs.x.ax = 0;
	mousecall ();
}

static
void
showmouse ()
{
	mregs.x.ax = 1;
	mousecall ();
}

void
hidemouse ()
{
	mregs.x.ax = 2;
	mousecall ();
}

void
mousestat ()
{
	mregs.x.ax = 3;
	mousecall ();
}

static mousebutton new_button;
static int new_x, new_y;

int
mousegetch ()
{
	int stat, x, y;

	showmouse ();
	mousestat ();
	stat = mregs.x.bx;
	new_y = mregs.x.dx;
	new_x = mregs.x.cx;

/*	check key input with bioskey (1) or kbhit () */
	while (! kbhit () && mregs.x.bx == stat
		&& mregs.x.dx == new_y && mregs.x.cx == new_x)
	{
		mousestat ();
	}
	if (kbhit ()) {
		hidemouse ();
		return getch ();
	} else {
	/*	bx: button - 1 = left, 2 = right, 4 = middle
		cx: column * 8 (first is 0)
		dx: line * 8 (first is 0)
	*/
		if (mregs.x.bx == stat) {
			if (in_menu_mouse_mode) {
				new_button = movebutton;
			} else {
				return mousegetch ();
			}
		} else if (mregs.x.bx == 1) {
			new_button = leftbutton;
		} else if (mregs.x.bx == 4) {
			new_button = middlebutton;
		} else if (mregs.x.bx == 2) {
			new_button = rightbutton;
		} else {
			new_button = releasebutton;
		}
		hidemouse ();
		return -1;
	}
}


void
DIRECTdosmousegetxy ()
{
  mouse_lastbutton = mouse_button;
  if (mouse_button == leftbutton || mouse_button == rightbutton || mouse_button == middlebutton) {
	mouse_prevbutton = mouse_button;
  }
  mouse_lastxpos = mouse_xpos;
  mouse_lastypos = mouse_ypos;

  mouse_button = new_button;

  /*
	mouse_xpos: column (first is 0)
	mouse_ypos: line after menu (first is 0, menu line is -1)
  */
  mouse_ypos = (new_y >> 3) - MENU;
  mouse_xpos = new_x >> 3;
}


/*======================================================================*\
|*				End					*|
\*======================================================================*/
