/************************************************************

$Author: ahodgen $
$Date: 2002/08/10 00:20:42 $
$Name:  $
$Revision: 1.13 $

************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "callbacks.h"
#include "interface.h"
#include "details.h"
#include "search.h"
#include "bookmarks.h"
#include "mibtree.h"
#include "configuration.h"
#include "version.h"

GtkWidget *main_window;

int main(int argc, char **argv) {

  int ch;

  gtk_init (&argc, &argv);
  while((ch = getopt(argc,argv,"hv")) != -1) {
    switch(ch) {
      case 'h':
      case 'v':
	printf("mbrowse %s\n"
	       "Copyright 2002 Aaron Hodgen <ahodgen@munsterman.com>\n"
	       "This program comes with NO WARRANTY, to the extent permitted by law.\n"
	       "You may redistribute it under the terms of the GNU General Public License;\n"
	       "see the file named COPYING for details.\n",mbrowse_version);
	exit(EXIT_SUCCESS);
	break;
      default:
	break;
    }
  }
    load_bookmarks();
  main_window = create_main_window();
  create_mibtree_tab();
  create_detail_tab();
  create_search_tab();
  create_config_tab(3);
  init_stuff();
  gtk_widget_show(main_window);
  load_config();
  gtk_main();
  return(EXIT_SUCCESS);
}
