/*!******************************************************************************

  @file         hkb90.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        KB_sender_receiver

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HKB90_H
#define HKB90_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x47\xc0\x5a\xd9\x71\xcc\xe9\x21\xea\x79\x5f\x33\xdd\x7d\xa7\x7b'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal pasbool k90all_server_ready (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90allocate_netserver (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90child_reply (
    tgg00_MessBlock       &  mblock,
    tsp00_Int2               ServerIndex,
    tgg00_TransChild      &  ChildTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90clear_netserver (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90dump_netserver (
    tgg00_VfFileref       &  HostFile,
    tsp00_Page            &  buf,
    tsp00_Int4            &  OutPno,
    integer               &  OutPos,
    tsp00_VfReturn        &  HostError,
    tsp00_ErrText         &  ErrorText);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 k90free_requests (
    tsp00_TaskId             TaskId,
    tgg00_MessType_Param     mtype,
    pasbool                  InRegion);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90rcv_child (
    tgg00_MessBlock       &  mblock,
    tgg00_TransChild      &  ChildTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90send (
    tgg00_MessBlock       &  mblock,
    tgg00_TransChild      &  ChildTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90send_prefix_destroy_files (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90server_init (
    tgg00_TransContext    &  Trans,
    tsp00_Int2            &  ServerIndex,
    pasbool               &  IsDynamic);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90sreceive_server (
    tgg00_MessBlock       &  mblock,
    tsp00_Int2               ServerIndex,
    pasbool                  AlreadyIdle,
    tgg00_TransChild      &  ChildTrans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k90wait_until_server_finished (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb90AddToPrefixDestroyFile (
    tgg00_TransContext    &  trans,
    tgg91_TransNo            fileTransId);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

