/*!******************************************************************************

  @file         hbd20.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        BD-data-cache

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD20_H
#define HBD20_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xc9\x11\xdd\x4e\x6d\x39\x75\x9a\x5a\x99\x8b\x6e\x62\x06\xa5\xc9'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"
#include "gbd02.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void bd20CheckExclusiveLockedPageForIO (
    tsp00_TaskId             TaskId,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tbd02_RecoveryMode_Param     recMode,
    tbd_nodeptr              pCBlock,
    pasbool               &  bWritePage,
    tbd02_CachePageState  &  PageState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20CheckRootNptrs (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tsp00_PageNo             Root,
    tbd_nodeptr              pNode,
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20LockPageForFree (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tbd02_RecoveryMode_Param     recMode,
    pasbool                  FirstCall,
    pasbool               &  PageLockedToFree,
    tbd02_CachePageState  &  PageState,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20FreePage (
    tsp00_TaskId             TaskId,
    tsp00_PageNo             PageNo,
    tbd02_RecoveryMode_Param     recMode,
    tgg00_BasisError      &  TrError,
    tsp00_Int2            &  ExclFileLockCnt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20FlushDataCache (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ForcedIODone (
    tbd_nodeptr              pCBlock,
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20GetPage (
    tsp00_TaskId             TaskId,
    tgg00_WaitContext     &  WaitContext,
    tgg00_BasisError      &  TrError,
    tsp00_Int2            &  ExclFileLockCnt,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tbd02_RecoveryMode_Param     recMode,
    tbd_node_request_Param     NodeRequest,
    tbd_nodeptr           &  nptr,
    tbd_nodeptr &            cbptr,
    tbd02_CachePageState  &  PageState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20InitDataCache (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tsp00_Int4               TotalFreeFrames,
    tsp00_Int4               TotalDataPages);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd20IsPageChanged (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd20IsPageExclusiveLocked (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool bd20IsPageShareLocked (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int2 bd20GetPageUsageCount (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20NewPage (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tgg00_FileId          &  FileId,
    tsp00_PageNo             PageNo,
    tbd02_RecoveryMode_Param     recMode,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr,
    tbd02_CachePageState  &  PageState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ProtectDataCacheFrames (
    tsp00_TaskId             TaskId,
    pasbool                  Enable);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20RReleasePage (
    tsp00_TaskId             TaskId,
    tsp00_Int2            &  ExclFileLockCnt,
    tgg00_FileId          &  FileId,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr,
    tbd02_RecoveryMode_Param     recMode,
    tbd_lru_info_Param       LruInfo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20WReleasePage (
    tsp00_TaskId             TaskId,
    tgg00_FileId          &  FileId,
    tsp00_Int2            &  ExclFileLockCnt,
    tbd_nodeptr           &  nptr,
    tbd02_pDataCBlock     &  cbptr,
    tbd02_SwapState       &  IoState,
    tbd02_RecoveryMode_Param     recMode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ReplaceOldOccupant (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tsp00_PageNo             PageNo,
    tbd02_RecoveryMode_Param     recMode,
    tbd_nodeptr              cbptr,
    pasbool                  setBlockedForNewNode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ShutdownDataCache (
    tsp00_TaskId             TaskId,
    pasbool                  emergency_shutdown);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20UsePage (
    tsp00_TaskId             TaskId,
    tgg00_BasisError      &  TrError,
    tsp00_PageNo             PageNo,
    tbd02_RecoveryMode_Param     recMode,
    tbd_nodeptr              cbptr,
    tbd_node_request_Param     NodeRequest,
    tbd_nodeptr           &  nptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20ClearAccessStatistic (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_Tfn_Param bd20GetFileTfn (
    tbd_nodeptr              pCBlock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void bd20GetAccessStatistic (
    tsp00_TaskId             TaskId,
    tsp00_8ByteCounter    &  HistoryTotal,
    tsp00_8ByteCounter    &  HistoryHit,
    tsp00_8ByteCounter    &  HistoryMiss,
    tsp00_8ByteCounter    &  OmsDataTotal,
    tsp00_8ByteCounter    &  OmsDataHit,
    tsp00_8ByteCounter    &  OmsDataMiss,
    tsp00_8ByteCounter    &  SqlDataTotal,
    tsp00_8ByteCounter    &  SqlDataHit,
    tsp00_8ByteCounter    &  SqlDataMiss);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

