#ifndef __OMS_DATETIME_HPP
#define __OMS_DATETIME_HPP

#include "Oms/OMS_AFX.h"

#define OMS_DT_SEC_PER_HOUR 3600L  // 60*60

class AFX_EXT_CLASS OMS_DateTime
{
public:
  OMS_DateTime() { dtValue = 0; }
  OMS_DateTime( long year, long month, long day, long hour, long min, long sec );

  unsigned long getDTValue ( void ) const { return dtValue; }
  int seconds( void ) const { return dtValue%60; }
  int minutes( void ) const { return (dtValue/60)%60; }
  int hours  ( void ) const { return (dtValue/OMS_DT_SEC_PER_HOUR)%24; }
  int day    ( void ) const;
  int month  ( void ) const;
  int year   ( void ) const;
private:
  unsigned long dtValue;
};

/*----------------------------------------------------------------------*/

extern 
void omsGetLocalDateTimeString(char*, int);

/*----------------------------------------------------------------------*/

extern
void omsGetLocalDateTime(int& year,
                         int& month,
                         int& day,
                         int& hours,
                         int& minutes,
                         int& seconds);

/*----------------------------------------------------------------------*/

extern
void omsGetUTCDateTimeString(char*, int);

/*----------------------------------------------------------------------*/

extern
void omsGetUTCDateTime(int& year,
                       int& month,
                       int& day,
                       int& hours,
                       int& minutes,
                       int& seconds);

#endif // __OMS_DATETIME_HPP