#ifndef CONFIG_H
#define CONFIG_H

#define __STRICT_ANSI__

#ifndef NULL
#define NULL 0
#endif

#define countones(g) (((g&1)==1)+((g&2)==2)+((g&4)==4)+((g&8)==8)+((g&16)==16)+((g&32)==32)+((g&64)==64)+((g&128)==128)+((g&256)==256)+((g&512)==512)+((g&1024)==1024)+((g&2048)==2048)+((g&4096)==4096)+((g&8192)==8192)+((g&16384)==16384))
#define random(r) (rand()%(r))

#define VERSION "1.0"

#define N_OF_SPECIES 5
#define N_OF_ITEMS 20
#define N_OF_CRPIC 8

#define NORTH 0
#define WEST 1
#define SOUTH 2
#define EAST 3

#define MILKACOW 0
#define LION 1
#define JERREMIAH 2
#define FISH 3
#define YOURCREATURE 4

#define VOID  0
#define MEAT 1
#define WATERPLANT 4
#define WOOD   5
#define STONE 6
#define FIRE 7
#define GRASS 8
#define ROCK1 9
#define ROCK2 10
#define ROCK3 11
#define RIVER 12
#define WATER 13
#define SUPERROCK 14

#define DOES_NOT_EXIST 0
#define DEAD 1
#define ALIVE 2

#define SLEEP 0
#define RUN 1
#define ATTACK 2
#define EAT 3
#define TAKE 4
#define MULTIPLY 5

#define MAPWIDTH 256
#define MAPHEIGHT 256

#define POPMEM 1024

extern unsigned char* p[MAPWIDTH];

extern unsigned int number_of[N_OF_SPECIES], number_of_dead[N_OF_SPECIES],
  atterrain[16],atdiet[16];
extern int dx[4],dy[4];
extern unsigned long turn;
extern int pop[POPMEM][N_OF_SPECIES];
extern int seedrand;

void error(char* code,int var1=0,int var2=0, int var3=0, int var4=0);
void itostr(int n, char*s);
#endif
