/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mray.cpp,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */
#define _MATH3D_EXPORT
#include <math3d/mray.h>


/*!
 * 
 */
Math3d::MRay::MRay()
  : d_pos(), d_dir(1.0,0,0) 
{
}


/*!
 * 
 */
Math3d::MRay::MRay(const M3d& pos, const M3d& dir) 
  : d_pos(pos), d_dir(dir) 
{
}


/*!
 *
 */
Math3d::MRay::MRay(const MRay& ray)
  : d_pos(ray.d_pos), d_dir(ray.d_dir) 
{
}


/*!
 *
 */
const Math3d::MRay&
Math3d::MRay::operator=(const MRay& ray)
{
  d_pos=ray.d_pos;
  d_dir=ray.d_dir;
  return(*this);
}


/*!
 *
 */
void
Math3d::MRay::copy(const MRay& ray)
{
  d_pos=ray.d_pos;
  d_dir=ray.d_dir;
}


/*!
 *
 */
void
Math3d::MRay::set(const M3d& p, const M3d& q)
{
  d_pos=p;
  d_dir.sub(q,p);
}


/*!
 *
 */
void
Math3d::MRay::setTgt(const M3d& tgt)
{
  d_dir.sub(tgt,d_pos);
}


/*!
 * 
 */
Math3d::M3d
Math3d::MRay::evaluate(double t) const
{
  M3d r(d_dir);
  r*=t;
  r+=d_pos;
  return(r);
}


/*!
 *
 */
void
Math3d::MRay::setPos(const M3d& pos)
{
  d_pos=pos;
}


/*!
 *
 */
void
Math3d::MRay::setDir(const M3d& dir)
{
  d_dir=dir;
}


/*!
 *
 */
Math3d::M3d
Math3d::MRay::getTgt() const
{
  M3d tgt;
  tgt.add(d_pos,d_dir);
  return(tgt);
}


/*!
 *
 */
bool 
Math3d::MRay::operator==(const MRay& ray) const
{
  return(cmp(ray));
}


/*!
 *
 */
bool 
Math3d::MRay::operator!=(const MRay& ray) const
{
  return(!cmp(ray));
}


/*!
 *
 */
bool 
Math3d::MRay::cmp(const MRay& ray, double epsilon) const
{
  return(
    d_pos.cmp(ray.d_pos, epsilon) &&
    d_dir.cmp(ray.d_dir, epsilon)
  );
}








