/* *********************************************************************** */
/* A parser definition for Mailfilter's config files                       */
/* Copyright (c) 2000 - 2004  Andreas Bauer <baueran@in.tum.de>            */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,   */
/* USA.                                                                    */
/* *********************************************************************** */

%{
#include <iostream>
#include <FlexLexer.h>
extern "C" {
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
}
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "mailfilter.hh"
#include "Preferences.hh"
#include "i18n.hh"

// We want to give the Preferences object as parameter for yyparse
#define YYPARSE_PARAM parm

// The next two lines prevent me from a lot of compiler warnings
#define yylex() lexer->yylex()
extern FlexLexer* lexer;
extern int numLines;
extern string subfile;

extern "C" { 
  int yyparse(void*);
  int yywrap(void) {
    return 1;
  }
  void yyerror(const char* str) {
    std::cerr << PACKAGE_NAME << _(": Error: ") << str << _(" in file ") << subfile << _(" in line ") << (numLines+1) << "." << std::endl;
    exit(-1);
  }
}
%}

%union
{
	int number;
	char* sval;
}

%token <sval> ALLOW
%token <sval> DEL_DUPLICATES
%token <sval> DENY_NOCASE
%token <sval> DENY_CASE
%token <sval> DENY
%token <sval> LOGFILE
%token <sval> MAXLENGTH
%token <sval> MAXSIZE_ALLOW
%token <sval> MAXSIZE_DENY
%token <sval> MAXSIZE_SCORE
%token <sval> NORMAL
%token <sval> REG_CASE
%token <sval> REG_NEWL
%token <sval> REG_TYPE
%token <sval> SCORE
%token <sval> SCORE_CASE
%token <sval> SCORE_NOCASE
%token <sval> NSCORES
%token <sval> SERVER
%token <sval> USER
%token <sval> PASS
%token <sval> PROTOCOL
%token <sval> PORT
%token <sval> SHOW_HEADERS
%token <sval> TEST
%token <sval> TIMEOUT
%token <sval> VERBOSE
%token <sval> CKEYWD
%token <sval> NKEYWD
%token <sval> ID
%token <sval> OP
%token <sval> SCORE_VAL

%%
commands: /* empty */
        | commands command
        ;

command:
	char_keyword
	| num_keyword
	| score
	;

char_keyword:
	CKEYWD OP ID
	{
           try {
	      ((pref::Preferences*)parm)->keyword($1, $2, $3);
           }
           catch (...) {
              throw;
           }
	}
	;

num_keyword:
	NKEYWD OP ID
	{
	   try {
	     ((pref::Preferences*)parm)->keyword($1, $2, atoi($3));
	   }
	   catch (...) {
	     throw;
	   }
	}
	;

score:
	NSCORES SCORE_VAL OP ID
	{
	  try {
	    ((pref::Preferences*)parm)->keyword($1, atoi($2), $3, $4);
	  }
	  catch (...) {
	    throw;
	  }
	}
	;
%%
