// RegExp.cc - source file for the mailfilter program
// Copyright (c) 2000 - 2004  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#include <string>
extern "C" {
#include <unistd.h>
#include <regex.h>
}
#include "RegExp.hh"


using namespace std;


namespace re {


  RegExp::RegExp() {
  }


  RegExp::~RegExp() {
  }

  
  // We need the c_str() as regexec and regcomp need null-terminated C-style strings!
  int RegExp::comp(regex_t* preg, const string& regex, int cflags) {
    return regcomp(preg, regex.c_str(), cflags);
  }


  // We need the c_str() as regexec and regcomp need null-terminated C-style strings!
  int RegExp::exec(const regex_t* preg, const string& regex) {
    return regexec(preg, regex.c_str(), 0, NULL, 0);
  }
  
  
  // We need the c_str() as regexec and regcomp need null-terminated C-style strings!
  int RegExp::error(int errcode, const regex_t* preg, char* errbuf, size_t errbufsize) {
    return regerror(errcode, preg, errbuf, errbufsize);
  }
  
  
  void RegExp::free(regex_t* preg) {
    regfree(preg);
  }


}
