/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#ifndef wnioH
#define wnioH


#ifdef vms
#include <file.h>
#else
#include <sys/file.h>
#endif

#include <stdio.h>


#define    STDIN     0
#define    STDOUT    1
#define    STDERR    2


typedef FILE wn_FILE;
typedef wn_FILE *wn_file;
typedef void (*error_func_type)(char operation[],char file[],char failure[]);


extern wn_file wn_fopen();


#ifndef wnioC


#define fopen   fopen_illegal;
#define fclose  fopen_illegal;
#define fputs   fputs_illegal;
#define fgets   fgets_illegal;
#undef putc
#define putc    putc_illegal;
#undef getc
#define getc    getc_illegal;
#undef feof
#define feof    feof_illegal;

#define open    open_illegal;
#define close   close_illegal;
#define write   write_illegal;
#define read    read_illegal;


#define wn_fread fread
#define wn_fwrite fwrite


#endif

#define wn_stdout stdout
#define wn_stdin stdin
#define wn_stderr stderr



void wn_ioerrfpush(error_func_type pfunc);
void wn_ioerrfpop(void);

void wn_search_path_for_file(char **presult,char *path,char *filename);

wn_file wn_fopen(char file_name[],char type[]);
int wn_fclose(wn_file f);

int wn_fgets(char *s,int n,wn_file stream);
int wn_fputs(char *s,wn_file stream);
int wn_getchar(void);
int wn_getc(wn_file stream);
int wn_ungetc(int c,wn_file stream);
int wn_putc(char c,wn_file stream);
bool wn_feof(wn_file f);
int wn_fflush(wn_file stream);

wn_file wn_popen(char command[],char type[]);
int wn_pclose(wn_file f);

int wn_open(char *path,int flags,int mode);
int wn_close(int d);

int wn_write(int d,char *buf,int nbytes);
int wn_read(int d,char *buf,int nbytes);

int wn_mv(char from[],char to[]);
int wn_rm(char path[]);
void wn_rmf(char *path);
int wn_mkdir(char dir_name[]);
int wn_rmdir(char dir_name[]);
int wn_cd(char dir_name[]);
void wn_pushd(char dir_name[]);
void wn_popd(void);
int wn_pwd(char dir_name[]);
bool wn_file_exists(char path[]);
bool wn_is_directory(char path[]);


#endif
