#!/usr/bin/perl
$|++;
use LW;

my (%req);

my $XML = LW::xml_read_file('/root/xml/test.xml');

#open(OUT,">");

print <<EOT;
#!/usr/bin/perl
#
# This file is automatically generated by the libwhisker vulnxml2pl script
#

use LW;
my (%request, %response, %args);

if(scalar @ARGV == 0){
	print <<EOUsage;
Usage:
	-u url		[Required] URL to run against, in the form:
				http://hostname/page.html
				https://hostname:8080/dir/page.asp

EOUsage
	exit;
}

LW::utils_getopts( 'u:', \%args );
LW::http_init_request( \%request );
LW::utils_split_uri( $args{u}, \%request );
LW::http_fixup_request( \%request );

EOT

my %V;
my @names=qw(TestName TestVersion DateReleased DateUpdated Description
		Impact Recommendation);

foreach (@names){
	$V{$_}=LW::xml_get_element_value($XML, $_, 
		'/WebApplicationTest/TestDescription');
}

my $temp = LW::utils_text_wrapper( $V{Description} );

print <<EOT;
print <<HEADER;
Test: $V{TestName}	Version: $V{TestVersion}
Released: $V{DateReleased}	Updated: $V{DateUpdated}

Description:
$temp
HEADER

EOT

handle_step('/WebApplicationTest/Connection/Step');

sub handle_step {
	my $steproot = shift;
	my $num = LW::xml_gepv($XML,$steproot,'name');
	print "# Step $num\n";

	my $temp = item_decode('/Request/MessageHeader/Method', $steproot);
	print "\$request{whisker}->{method} = '$temp';\n" if(defined $temp);
	$temp = item_decode('/Request/MessageHeader/Version', $steproot);
	print "\$request{whisker}->{http_ver} = '$temp';\n" if(defined $temp);

	my @headers = LW::xml_get_multi($XML,'/Request/MessageHeader/Header',
		$steproot);
	foreach (@headers){
		my $name = LW::xml_gepv($XML,$_,'name');
		my $value = item_decode($_);
		print "\$request{'$name'}='$value';\n";
	}
}

sub item_decode {
	my ($item, $root) = @_;
	$item=LW::xml_join_name($item,$root) if(defined $root);
	my $enc = LW::xml_gepv($XML,$item,'encoding');
	my $val = LW::xml_gev($XML,$item);
	return $val if(!defined $enc);
	return undef if(!defined $val);
	if($enc eq 'base64'){
		return LW::decode_base64($val);
	}
	# default case, including 'text' encoding
	return $val;
}
