#include <tagcoll/TagcollConsumer.h>
#include <tagcoll/TagSet.h>
#include <tagcoll/InputMerger.h>
#include <tagcoll/TagToString.h>
#include <tagcoll/OpSet.h>
#include <tagcoll/Exception.h>

#include <map>
#include <string>

#include <stdarg.h>

using namespace std;
using namespace Tagcoll;

class PackageGatherer : public TagcollConsumer<string, Tag>
{
protected:
	OpSet<string> coll;
public:
	virtual ~PackageGatherer() throw () {}
	virtual void consume(const string& item) throw ()
	{
		coll += item;
	}
	virtual void consume(const string& item, const OpSet<Tag>& tags) throw ()
	{
		coll += item;
	}
	OpSet<string>& getColl() throw () { return coll; }
};

typedef map<string, OpSet<string> > coll_t;

static OpSet<string> makeSet(const char* first, ...)
{
	va_list ap;
	OpSet<string> res;
	va_start(ap, first);
	for ( ; first; first = va_arg(ap, const char*))
		res += first;
	va_end(ap);
	return res;
}

int main (int argc, char *argv[])
{
	try {
		// Install the handler for unexpected exceptions
		InstallUnexpected installUnexpected;

		int result = 0;

		coll_t origData;
		origData.insert(pair<string, OpSet<string> >("coyote",
					makeSet("animal", "mammal", "hungry", 0)));
		origData.insert(pair<string, OpSet<string> >("bird",
					makeSet("animal", "avian", "yummy", 0)));

		FacetSet vocabulary;
		InputMerger<string, Tag> collection;
		StringsToTags<string> conv(vocabulary, &collection);

		// Create the normal tags
		for (coll_t::const_iterator i = origData.begin();
				i != origData.end(); i++)
			conv.consume(i->first, i->second);
		
		// Compare two methods of getting tags
		for (coll_t::const_iterator i = origData.begin(); i != origData.end(); i++)
		{
			TagSet tsfirst = collection.getTagsetForItem(i->first);
			OpSet<string> tssecond = i->second;
			
			TagSet::const_iterator fi = tsfirst.begin();
			OpSet<string>::const_iterator si = tssecond.begin();
			for ( ; fi != tsfirst.end() && si != tssecond.end(); fi++, si++)
			{
				if (fi->fullname() != *si)
				{
					fprintf(stderr, "%.*s: tag differ [debtags]%.*s != [tagcoll]%.*s\n",
							PFSTR(i->first), PFSTR(fi->fullname()), PFSTR(*si));
					result = 1;
				}
			}
			for (; fi != tsfirst.end(); fi++)
			{
				fprintf(stderr, "%.*s: tag only in debtags: %.*s\n",
						PFSTR(i->first), PFSTR(fi->fullname()));
				result = 1;
			}
			for (; si != tssecond.end(); si++)
			{
				fprintf(stderr, "%.*s: tag only in tagcoll: %.*s\n",
						PFSTR(i->first), PFSTR(*si));
				result = 1;
			}
		}

		return result;
	} catch (Exception& e) {
		fprintf(stderr, "%s: %.*s\n", e.type(), PFSTR(e.desc()));
	}
}

// vim:set ts=4 sw=4:
