#ifndef TAGCOLL_BUILDER_H
#define TAGCOLL_BUILDER_H

/*
 * TagcollConsumer that builds a tagged collection
 * 
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/HandleMaker.h>
#include <tagcoll/TagcollConsumer.h>
#include <tagcoll/TagCollection.h>

namespace Tagcoll
{

// TagcollConsumer that builds a tagged collection 
class TagcollBuilder : public TagcollConsumer<std::string>
{
protected:
	HandleMaker<std::string>& handleMaker;
	TagCollection<int, std::string> coll;

	OpSet<int> itemsToHandles(const OpSet<std::string>& ts) throw ()
	{
		OpSet<int> res;
		for (OpSet<std::string>::const_iterator i = ts.begin();
				i != ts.end(); i++)
			res += handleMaker.getHandle(*i);
		return res;
	}
	
public:
	TagcollBuilder(HandleMaker<std::string>& handleMaker) throw ()
		: handleMaker(handleMaker) {}
	virtual ~TagcollBuilder() throw () {}

	virtual void consume(const std::string& item) throw ()
	{
		coll.add(handleMaker.getHandle(item));
	}
	
	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ()
	{
		coll.add(tags, handleMaker.getHandle(item));
	}

	virtual void consume(const OpSet<std::string>& items) throw ()
	{
		coll.add(itemsToHandles(items));
	}
	
	virtual void consume(const OpSet<std::string>& items, const OpSet<std::string>& tags) throw ()
	{
		coll.add(tags, itemsToHandles(items));
	}

	// Retrieve the resulting collection
	TagCollection<int, std::string> collection() throw () { return coll; }
	const TagCollection<int, std::string> collection() const throw () { return coll; }
};

};

// vim:set ts=4 sw=4:
#endif
