/*
 * Merge tags of items appearing multiple times in a stream of tagged items
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include <tagcoll/InputMerger.h>

using namespace std;
using namespace Tagcoll;

//template class InputMerger<string>;
//template class InputMerger<int>;
//
//namespace Debtags { class Package; }
//template class InputMerger<Debtags::Package*>;

template<class T, class Tag>
void InputMerger<T, Tag>::consume(const T& item) throw ()
{
	typename map< T, OpSet<Tag> >::iterator i = coll.find(item);
	if (i == coll.end())
		coll.insert(make_pair(item, OpSet<Tag>()));
}

template<class T, class Tag>
void InputMerger<T, Tag>::consume(const T& item, const OpSet<Tag>& tags) throw ()
{
	typename map< T, OpSet<Tag> >::iterator i = coll.find(item);
	if (i == coll.end())
		coll.insert(make_pair(item, tags));
	else
		i->second += tags;
}

template<class T, class Tag>
OpSet<Tag> InputMerger<T, Tag>::getTagsetForItem(const T& item) const throw ()
{
	typename map< T, OpSet<Tag> >::const_iterator i = coll.find(item);
	
	if (i == coll.end())
		return OpSet<Tag>();
	else
		return i->second;
}
	

template<class T, class Tag>
void InputMerger<T, Tag>::output(TagcollConsumer<T, Tag>& consumer) const throw ()
{
	for (typename map< T, OpSet<Tag> >::const_iterator i = coll.begin();
			i != coll.end(); i++)
		if (i->second.size() == 0)
			consumer.consume(i->first);
		else
			consumer.consume(i->first, i->second);
}


template<class T, class Tag>
TagcollChange<T, Tag> InputMerger<T, Tag>::applyChange(
		const TagcollChange<T, Tag>& change) throw ()
{
	TagcollChange<T, Tag> rev;

	for (typename TagcollChange<T, Tag>::const_iterator i = change.begin(); i != change.end(); i++)
	{
		typename map< T, OpSet<Tag> >::iterator it = coll.find(i->first);
		if (it == coll.end())
		{
			// If the item doesn't exist, create it
			rev.insert(make_pair(i->first, OpSet<Tag>()));
			coll.insert(make_pair(i->first, i->second));
		} else {
			rev.insert(make_pair(it->first, it->second));
			it->second = i->second;
		}
	}

	return rev;
}

template<class T, class Tag>
OpSet<Tag> InputMerger<T, Tag>::getAllTags() const throw ()
{
	OpSet<Tag> tags;

	for (typename map< T, OpSet<Tag> >::const_iterator i = coll.begin();
			i != coll.end(); i++)
		tags += i->second;
	
	return tags;
}

template<class T, class Tag>
OpSet<Tag> InputMerger<T, Tag>::getCompanionTags(const OpSet<Tag>& ts) const throw ()
{
	OpSet<Tag> tags;

	for (typename map< T, OpSet<Tag> >::const_iterator i = coll.begin();
			i != coll.end(); i++)
		if (i->second.contains(ts))
			tags += i->second - ts;
	
	return tags;
}

template<class T, class Tag>
OpSet<T> InputMerger<T, Tag>::getRelatedItems(const T& item, int maxdistance) const throw ()
{
	OpSet<T> res;

	typename map< T, OpSet<Tag> >::const_iterator base = coll.find(item);
	if (base == coll.end())
		return res;

	res = getRelatedItems(base->second, maxdistance);
	if (res.contains(item))
		res -= item;

	return res;
}

template<class T, class Tag>
OpSet<T> InputMerger<T, Tag>::getRelatedItems(const OpSet<Tag>& tags, int maxdistance) const throw ()
{
	OpSet<T> res;

	for (typename map< T, OpSet<Tag> >::const_iterator i = coll.begin();
			i != coll.end(); i++)
	{
		int dist = tags.distance(i->second);
		if (dist >= 0 && dist <= maxdistance)
			res += i->first;
	}
	
	return res;
}

template<class T, class Tag>
OpSet<T> InputMerger<T, Tag>::getItemsContaining(const OpSet<Tag>& ts) const throw ()
{
	OpSet<T> res;

	for (typename map< T, OpSet<Tag> >::const_iterator i = coll.begin();
			i != coll.end(); i++)
		if (i->second.contains(ts))
			res += i->first;
	
	return res;
}


// vim:set ts=4 sw=4:
