/*
 * TagcollFilter that filters items using a tag expression
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include <tagcoll/ExpressionFilter.h>

#include <tagcoll/tagexpr/TagexprParser.h>

#include <tagcoll/stringf.h>

using namespace std;
using namespace Tagcoll;

bool ExpressionFilter::setExpression(const std::string& expression) throw ()
{
	return (expr = TagexprParser::instance()->parse(expression)) != 0;
}

bool ExpressionFilter::match(const OpSet<string>& tags) const throw ()
{
	if (matchType == PLAIN)
		return expr->eval(tags);
	else
		return !expr->eval(tags);
}
	
// vim:set ts=4 sw=4:
