
docdir=doc/api
test -d $docdir || {
    cat <<EOF
The toc-standard API doc directory, $docdir, not found. Skipping API
doc generation checks.
EOF
    return 0 # yes, 0.
}

# find optional kdoc/doxygen
toc_find_in_path kdoc /usr/local/bin:/opt/kde{2,3}/bin:$HOME/bin:$PATH > /dev/null
KDOC_BIN=$TOC_FIND_RESULT
# boldecho KDOC_BIN=$KDOC_BIN

toc_find_in_path doxygen /usr/loca/bin:$HOME/bin:$PATH > /dev/null
DOXYGEN_BIN=$TOC_FIND_RESULT

toc_add_make DOXYGEN_BIN=$DOXYGEN_BIN
toc_add_make KDOC_BIN=$KDOC_BIN

test -n "$KDOC_BIN" -o -n "$DOXYGEN_BIN" && {
    CONF_TEST_ERR=0
} || {
    CONF_TEST_ERR=1
}


cat <<EOF
To build the API documentation you can:
  cd doc/api; make [doxygen|kdoc]
EOF

return 0