# tests for imagemagick tools (www.imagemagick.org).
#

if test "x${configure_with_imagemagick}" = "x0"; then
    echo "ImageMagick tests have been explicitely disabled. Use --with-imagemagick to enable them."
    return 1
fi

imprefix=${configure_with_imagemagick-${prefix}}

configure_with_imagemagick=0
toc_add_make HAVE_IMAGEMAGICK=0

binpath=$imprefix/bin:/usr/bin:/usr/local/bin:/opt
echo "Looking for binaries... "
for bin in \
            Magick++-config=IM_MAGICKPP_CONFIG \
            Magick-config=IM_MAGICK_CONFIG \
            PerlMagick=IM_PERLMAGICK \
            animate=IM_ANIMATE \
            composite=IM_COMPOSITE \
            conjure=IM_CONJURE \
            convert=IM_CONVERT \
            display=IM_DISPLAY \
            identify=IM_IDENTIFY \
            import=IM_IMPORT \
            mogrify=IM_MOGRIFY \
            montage=IM_MONTAGE \
            ; do
                k=${bin%%=*}
                v=${bin##*=}
                toc_find $k $binpath && {
		    toc_export $v=${TOC_FIND_RESULT}
		} || {
		    echo "Did not find $k"
		    return 1
		}
done
# > /dev/null

echo "Looking for libraries.."
libpath=$imprefix/lib:/usr/lib:/usr/local/lib:/opt
for lib in libMagick++=IM_LIBMAGICKPP libMagick=IM_LIBMAGICK; do
        k=${lib%%=*}.a
        v=${lib##*=}
        toc_find $k $libpath && toc_add_make $v=${TOC_FIND_RESULT}
done
# > /dev/null

incpath=$imprefix/include:/usr/include:/usr/local/include
echo "Looking for headers..."
iminc=
for p in Magick++.h magick/blob.h Magick++/Blob.h; do
    toc_find $p $incpath || continue
    iminc="${TOC_FIND_RESULT%/*} $iminc"
done
# > /dev/null
toc_add_make IM_INCLUDES_PATH="$iminc"

toc_add_make HAVE_IMAGEMAGICK=1
configure_with_imagemagick=1
return 0
