// This is a roxen module. (c) Martin Baehr 1996

// The asis module. returns documents without any change.

//  This code is (c) 1997 Martin Baehr, and can be used, modified and
//  redistributed freely under the terms of the GNU General Public License,
//  version 2.
//  This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
//  implicit or explicit. Use at your own risk.
//  You can modify this code as you wish, but in this case please
//  - state that you changed the code in the modified version
//  - do not remove my name from it
//  - send me a copy of the modified version or a patch, so that
//    I can include it in the 'official' release.
//  If you find this code useful, please e-mail me. It would definitely
//  boost my ego :)
//  
//  For risks and side-effects please read the code or ask your local 
//  unix or roxen-guru.

string cvs_version = "$Id: asis.pike, v 0.9 1997/1/31 mb Exp $";

#include <module.h>

inherit "module";
inherit "roxenlib";

void create()
{
  defvar("extensions",
         ({ "asis" }),
         "extensions",
         TYPE_STRING_LIST,
         "The files with these extensions will be returned <i>asis</i>.<br>\n"
         "yet for some reason you need to reload the module to activate the " 
         "changes.<br>\n"
         "if you know how to fix this, please mail me at: "
         "<a href=\"mailto:mbaehr@iaeste.or.at?Subject=roxen asis.pike fix\">"
         "mbaehr@iaeste.or.at</a>"
        );
}

mixed *register_module()
{
  return ({
    MODULE_FILE_EXTENSION, 
      "asis module",
      "This module is the Roxen equivalent to the asis module in Apache.<br>"
      "It's purpose is to allow asis documents created for Apache be served by" 
      " Roxen <P> "
      "The contents of any file with an"
      " extension listed below will be sent to the client without "
      "any changes. Clients will need HTTP headers to be attached, so do not "
      "forget them. A Status: header is also required; the data should be the "
      "3-digit HTTP response code, followed by a textual message.<p>\n"
      "\n"
      "Here's an example of a file whose contents are sent <em>as is</em> "
      "so as to tell the client that a file has redirected."
      "<blockquote><code>"
      "Status: 302 Now where did I leave that URL <br>"
      "Location: http://xyz.abc.com/foo/bar.html <br>"
      "Content-type: text/html <br>"
      "<br>"
      "&lt;HTML&gt; <br>"
      "&lt;HEAD&gt; <br>"
      "&lt;TITLE&gt;Lame excuses'R'us&lt;/TITLE&gt; <br>"
      "&lt;/HEAD&gt; <br>"
      "&lt;BODY&gt; <br>"
      "&lt;H1&gt;Fred's exceptionally wonderful page has moved to <br>"
      "&lt;A HREF=\"http://xyz.abc.com/foo/bar.html\"&gt;Joe's&lt;/A&gt; site."
      "<br>"
      "&lt;/H1&gt; <br>"
      "&lt;/BODY&gt; <br>"
      "&lt;/HTML&gt;"
      "</code></blockquote>",
      0,
      1,
  });
}

array (string) query_file_extensions()
{
  return QUERY(extensions);
}

mapping handle_file_extension(object file, string ext, object id)
{
  return([ "file":file, "raw":1 ]);
}
  

