/***************************************************************************
                          hbcijob.cpp  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include <string>
#include <list>
#include "error.h"
#include "pointer.h"
#include "hbcistring.h"
#include "date.h"
#include "value.h"
#include "balance.h"
#include "auth.h"
#include "interactor.h"
#include "hbci.h"
#include "user.h"
#include "account.h"
#include "bpdjob.h"
#include "bank.h"
#include "job.h"

#include <stdio.h> // DEBUG

namespace HBCI {

Job::segResponse::segResponse()
    :code(0)
    ,replyTo(0)
{
}


Job::segResponse::segResponse(const string &response)
:code(0)
,replyTo(0)
{
    unsigned int pos;
    unsigned int groupPos;
    string group;
    string tmp;

    // get reply segment
    pos=0;
    group=String::nextDE(response, pos);
    groupPos=0;
    // skip segid
    groupPos+=String::nextDEG(group, groupPos).length() + 1;
    // skip segnum
    groupPos+=String::nextDEG(group, groupPos).length() + 1;
    // skip segver
    groupPos+=String::nextDEG(group, groupPos).length() + 1;
    // get reply segment
    replyTo=atoi(String::nextDEG(group, groupPos).c_str());

    // now get responses
    pos+=group.length() + 1;
    while (pos < response.length()) {
        group = String::nextDE(response, pos);
        pos += group.length() + 1;
        // response-code
        tmp = String::nextDEG(group, 0);
        groupPos = tmp.length() + 1;
        code = atoi(tmp.c_str());
        // additional information
        additional = String::nextDEG(group, groupPos);
        groupPos += additional.length() + 1;
        // response-text
        text = String::nextDEG(group, groupPos);		
        groupPos += text.length() + 1;
		text = String::unEscape(text);
        // parameter (the rest)
        param = String::nextDE(group, groupPos);
    }
}


Job::segResponse::~segResponse(){
}


string Job::segResponse::toString() const {
    string tmp;

    tmp=text;
    if (Hbci::debugLevel()==0) {
	tmp+=" (Code ";
	tmp+=String::num2string(code);
	if (!additional.empty()) {
	    tmp+=", ";
	    tmp+=additional;
	}
	tmp+=")";
    }
    else {
	tmp += "; Code " + String::num2string(code)
	    + ", replyTo " + String::num2string(replyTo);
	if (!param.empty()) 
	    tmp += ", param " + param;
	if (!additional.empty()) 
	    tmp += ", additional " + additional;
    }
    return tmp;
}



Job::Job(Pointer<Customer> cust)
:_customer(cust)
 ,_user(cust.ref().user())
{
    _customer.setDescription("Job::_customer");
    if (cust.isValid()) {
        _bank=_user.ref().bank();
    }
    _customer.setDescription("Job::_customer");
    _bank.setDescription("Job::_bank");

}


Job::~Job(){
}


void Job::jobSuccess(const string &response) {
    segResponse respStruct(response);

    _responses.push_back(respStruct);
    _bank.ref().hbci()->interactor().ref().msgStateResponse(respStruct.toString());
}


bool Job::containsSegment(int number) const {
    return ((_startSegment <= number) && (_lastSegment >= number));
}



const list<Job::segResponse> &Job::getSegmentResponse() const
{
    return _responses;
}


bool Job::hasErrors() const {
    list <segResponse>::const_iterator i;
    bool he;

    he=false;
    for (i=_responses.begin();
         i!=_responses.end();
         i++) {
        if ((*i).code>=9000)
            he=true;
    } // for
    return he;
}

bool Job::errorcodeIsLibraryBug(int errorcode) 
{
    switch (errorcode) {
    case 9030:
    case 9040:
    case 9110:
    case 9120:
    case 9130:
    case 9140:
    case 9145:
    case 9150:
    case 9160:
    case 9170:
    case 9210:
    case 9212:
    case 9215:
    case 9390:
	return true;
    case 9000:
    case 9010:
    case 9180:
    default:
	return false;
    }
}

} // namespace HBCI

int 
HBCI_Job_errorcodeIsLibraryBug(int errorcode)
{
    return HBCI::Job::errorcodeIsLibraryBug(errorcode);
}
