/************************************************

 intl.c

 Copyright (C) 1999 HIRATA Naoto

************************************************/
#include "ruby.h"
#include <libintl.h>
#ifdef HAVE_LOCALE_H
#  include <locale.h>
#endif

VALUE gIntl;

static VALUE intl_initialize( self, domain )
    VALUE self;
    VALUE domain;
{
    char* lang;
    Check_Type( domain, T_STRING );
/*    setlocale( LC_MESSAGES, "" );*/
    if ( lang = getenv( "LC_ALL" ) )
        setlocale( LC_ALL, lang );
    else if ( lang = getenv( "LANG" ) )
        setlocale( LC_ALL, lang );
    else
        setlocale( LC_ALL, "" );
    textdomain( STR2CSTR( domain ) );

    return Qnil;
}

static VALUE intl_bindtextdomain( self, domain, dirname )
    VALUE self;
    VALUE domain;
    VALUE dirname;
{
    char* new_dirname;

    Check_Type( domain, T_STRING );
    switch( TYPE( dirname ) ) {
    case T_STRING:
        new_dirname = bindtextdomain( STR2CSTR( domain ), STR2CSTR( dirname ) );
        break;
    case T_NIL:
        new_dirname = bindtextdomain( STR2CSTR( domain ), NULL );
        break;
    default:
        rb_raise( rb_eTypeError, "dirname is Not String or Null" );
    }

    return rb_str_new2( new_dirname );
}

static VALUE intl_dcgettext( self, domain, msgid, category )
    VALUE self;
    VALUE domain;
    VALUE msgid;
    VALUE category;
{
    char* msgstr;

    Check_Type( domain, T_STRING );
    Check_Type( msgid, T_STRING );
    Check_Type( category, T_FIXNUM );
    msgstr = dcgettext( STR2CSTR( domain ), STR2CSTR( msgid ), FIX2INT( category ) );

    return rb_str_new2( msgstr );
}

static VALUE intl_dgettext( self, domain, msgid )
    VALUE self;
    VALUE domain;
    VALUE msgid;
{
    char* msgstr;

    Check_Type( domain, T_STRING );
    Check_Type( msgid, T_STRING );
    msgstr = dgettext( STR2CSTR( domain ), STR2CSTR( msgid ) );

    return rb_str_new2( msgstr );
}

static VALUE intl_gettext( self, msgid )
    VALUE self;
    VALUE msgid;
{
    char* msgstr;

    Check_Type( msgid, T_STRING );
    msgstr = gettext( STR2CSTR( msgid ) );

    return rb_str_new2( msgstr );
}

static VALUE intl_textdomain( self, domain )
    VALUE self;
    VALUE domain;
{
    char* new_domain;

    Check_Type( domain, T_STRING );
    new_domain = textdomain( STR2CSTR( domain ) );

    return rb_str_new2( new_domain );
}

void Init_intl()
{
    gIntl = rb_define_class( "Intl", rb_cObject );
    rb_define_method( gIntl, "initialize", intl_initialize, 1 );
    rb_define_method( gIntl, "gettext", intl_gettext, 1 );
    rb_define_method( gIntl, "_", intl_gettext, 1 );
    rb_define_method( gIntl, "bindtextdomain", intl_bindtextdomain, 2 );
    rb_define_method( gIntl, "dcgettext", intl_dcgettext, 3 );
    rb_define_method( gIntl, "dgettext", intl_dgettext, 2 );
    rb_define_method( gIntl, "textdomain", intl_textdomain, 1 );

    rb_define_const( gIntl, "LC_ALL", INT2FIX( LC_ALL ) );
    rb_define_const( gIntl, "LC_COLLATE", INT2FIX( LC_COLLATE ) );
    rb_define_const( gIntl, "LC_CTYPE", INT2FIX( LC_CTYPE ) );
    rb_define_const( gIntl, "LC_MESSAGES", INT2FIX( LC_MESSAGES ) );
    rb_define_const( gIntl, "LC_MONETARY", INT2FIX( LC_MONETARY ) );
    rb_define_const( gIntl, "LC_NUMERIC", INT2FIX( LC_NUMERIC ) );
    rb_define_const( gIntl, "LC_TIME", INT2FIX( LC_TIME ) );
}
