/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  types.cc - Pango types C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "types.h"

using namespace Inti;

Pango::Rectangle::Rectangle()
{
	set(0, 0, 0, 0);
}

Pango::Rectangle::Rectangle(int x, int y, int width, int height)
{
	set(x, y, width, height);
}

Pango::Rectangle::Rectangle(const PangoRectangle& rectangle)
{
	set(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
}

Pango::Rectangle::operator PangoRectangle* () const
{
	return this ? pango_rectangle() : 0; 
}

int
Pango::Rectangle::x() const
{
	return rectangle_.x;
}

int
Pango::Rectangle::y() const
{
	return rectangle_.y;
}

int
Pango::Rectangle::width() const
{
	return rectangle_.width;
}

int
Pango::Rectangle::height() const
{
	return rectangle_.height;
}

int
Pango::Rectangle::ascent() const
{
	return PANGO_ASCENT(*pango_rectangle());
}

int
Pango::Rectangle::descent() const
{
	return PANGO_DESCENT(*pango_rectangle());
}

int
Pango::Rectangle::lbearing() const
{
	return PANGO_LBEARING(*pango_rectangle());
}

int
Pango::Rectangle::rbearing() const
{
	return PANGO_RBEARING(*pango_rectangle());
}

void
Pango::Rectangle::set(int x, int y, int width, int height)
{
	rectangle_.x = x;
	rectangle_.y = y;
	rectangle_.width = width;
	rectangle_.height = height;
}

