/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/gtk/menubar.h
//! @brief A GtkMenuBar C++ wrapper interface.
//!
//! Provides MenuBar, a widget subclass of MenuShell which contains one to many MenuItem.
//! The result is a standard menu bar which can hold many menu items.

#ifndef INTI_GTK_MENU_BAR_H
#define INTI_GTK_MENU_BAR_H

#ifndef INTI_GTK_MENU_SHELL_H
#include <inti/gtk/menushell.h>
#endif

#ifndef __GTK_MENU_BAR_H__
#include <gtk/gtkmenubar.h>
#endif

namespace Inti {

namespace Gtk {

class MenuBarClass;

//! @class MenuBar menubar.h inti/gtk/menubar.h
//! @brief A GtkMenuBar C++ wrapper class.
//!
//! The MenuBar is a subclass of MenuShell which contains one or more MenuItem.
//! The result is a standard menu bar which can hold many menu items. MenuBar
//! allows for a shadow type to be set for aesthetic purposes.

class MenuBar : public MenuShell
{
	friend class G::Object;
	friend class MenuBarClass;

	MenuBar(const MenuBar&);
	MenuBar& operator=(const MenuBar&);
	
protected:
//! @name Constructors
//! @{

	explicit MenuBar(GtkMenuBar *menu_bar, bool reference = false);
	//!< Construct a new MenuBar from an existing GtkMenuBar.
	//!< @param menu_bar A pointer to a GtkMenuBar.
	//!< @param reference Set false if the initial reference count is floating, set true if it's not.
	//!<
	//!< <BR>The <EM>menu_bar</EM> can be a newly created GtkMenuBar or an existing
	//!< GtkMenuBar (see G::Object::Object).

//! @}

public:
//! @name Constructors
//! @{

	MenuBar();
	//!< Construct a new MenuBar.

	virtual ~MenuBar();
	//!< Destructor.
	
//! @}
//! @name Accessors

	GtkMenuBar* gtk_menu_bar() const { return (GtkMenuBar*)instance; }
	//!< Get a pointer to the GtkMenuBar structure.

	GtkMenuBarClass* gtk_menu_bar_class() const;
	//!< Get a pointer to the GtkMenuBarClass structure.

	operator GtkMenuBar* () const;
	//!< Conversion operator; safely converts a MenuBar to a GtkMenuBar pointer.

//! @}
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_MENU_BAR_H

