/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  object_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_OBJECT_CLASS_H
#define INTI_ATK_OBJECT_CLASS_H

#include <inti/glib/private/object_p.h>

namespace Inti {

namespace Atk {

class ObjectClass
{
public:
	static void init(AtkObjectClass *g_class);

	static GType get_type();

	static void* create();

// Methods
	static const gchar* get_name_proxy(AtkObject *accessible);

	static const gchar* get_description_proxy(AtkObject *accessible);

	static AtkObject* get_parent_proxy(AtkObject *accessible);

	static gint get_n_children_proxy(AtkObject *accessible);

	static AtkObject* ref_child_proxy(AtkObject *accessible, gint i);

	static gint get_index_in_parent_proxy(AtkObject *accessible);

	static AtkRelationSet* ref_relation_set_proxy(AtkObject *accessible);

	static AtkRole get_role_proxy(AtkObject *accessible);

	static AtkLayer get_layer_proxy(AtkObject *accessible);

	static gint get_mdi_zorder_proxy(AtkObject *accessible);

	static AtkStateSet* ref_state_set_proxy(AtkObject *accessible);

	static void set_name_proxy(AtkObject *accessible, const gchar *name);

	static void set_description_proxy(AtkObject *accessible, const gchar *description);

	static void set_parent_proxy(AtkObject *accessible, AtkObject *parent);

	static void set_role_proxy(AtkObject *accessible, AtkRole role);

// Signals
	static void children_changed_proxy(AtkObject *accessible, guint change_index, gpointer changed_child);

	static void focus_event_proxy(AtkObject *accessible, gboolean focus_in);

	static void property_change_proxy(AtkObject *accessible, AtkPropertyValues *values);

	static void state_change_proxy(AtkObject *accessible, const gchar *name, gboolean state_set);

	static void visible_data_changed_proxy(AtkObject *accessible);

	static void active_descendant_changed_proxy(AtkObject *accessible, gpointer *child);
};

class ImplementorIface
{
public:
	static void init(AtkImplementorIface *g_iface);

	static AtkObject* ref_accessible_proxy(AtkImplementor *implementor);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_OBJECT_CLASS_H
