/*  Inti-GConf: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  internals.h - Vector to GSList, private interface.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GCONF_INTERNALS_H
#define INTI_GCONF_INTERNALS_H

#ifndef __G_SLIST_H__
#include <glib/gslist.h>
#endif

#ifndef INTI_STRING_H
#include <inti/utf-string.h>
#endif

#ifndef CPP_VECTOR_H
#include <vector>
#endif

namespace Inti {

namespace GConf {

class Schema;

GSList* vector_to_gslist(const String& key, const std::vector<int>& list);

GSList* vector_to_gslist(const String& key, const std::vector<bool>& list);

GSList* vector_to_gslist(const String& key, const std::vector<double>& list);

GSList* vector_to_gslist(const String& key, const std::vector<String>& list);

GSList* vector_to_gslist(const String& key, const std::vector<Schema>& list);

} // namespace GConf

} // namespace Inti

#endif // INTI_GCONF_INTERNALS_H

