/*
******************************************************************************

   Demo of the GCP extension.

   Authors:	2000 Christoph Egger	[Christoph_Egger@t-online.de]
  
   This code is placed in the public domain and may be used freely for any
   purpose.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <ggi/ggi.h>
#include <ggi/gcp.h>


void do_demo(ggi_visual_t vis)
{
	int i,j;


	gcp_RGBAcolor rgba;
	gcp_RGBAcolor rgba2;
	gcp_HSVcolor hsv;
	gcp_YUVcolor yuv;
	gcp_CMYKcolor cmyk;

	gcp_pixel rgba_pixel;
	gcp_pixel rgba2_pixel;
	gcp_pixel hsv_pixel;
	gcp_pixel yuv_pixel;
	gcp_pixel cmyk_pixel;




	gcp_pixel col1_pixel;
	gcp_pixel col2_pixel;
	gcp_pixel col3_pixel;
	gcp_pixel blend_pixel;


	gcpSetColorfulPalette(vis);


	/* Change this, if you want to test color-blending
	 * with different color-values.
	 */
	rgba.r = 0xFFFF;
	rgba.g = 0x0000;
	rgba.b = 0x0000;
	rgba.a = 0xFFFF;

	rgba2.r = 0x0000;
	rgba2.g = 0x0000;
	rgba2.b = 0xFFFF;
	rgba2.a = 0xFFFF;


	hsv.h = 1.0f;
	hsv.s = 1.0f;
	hsv.v = 1.0f;

	yuv.y = 1.0f;
	yuv.u = 1.0f;
	yuv.v = 1.0f;

	cmyk.c = 0x7777;
	cmyk.m = 0xFFFF;
	cmyk.y = 0x7777;
	cmyk.k = 0x6666;


	printf("rgba (0x%X,0x%X,0x%X,0x%X)\n",
		rgba.r, rgba.g, rgba.b, rgba.a);

	printf("rgba2 (0x%X,0x%X,0x%X,0x%X)\n",
		rgba2.r, rgba2.g, rgba2.b, rgba2.a);

	printf("hsv (%.02f,%.02f,%.02f)\n",
		hsv.h, hsv.s, hsv.v);

	printf("yuv (%.02f,%.02f,%.02f)\n",
		yuv.y, yuv.u, yuv.v);

	printf("cmyk (0x%X,0x%X,0x%X,0x%X)\n",
		cmyk.c, cmyk.m, cmyk.y, cmyk.k);


	rgba_pixel = gcpMapRGBAColor(vis, &rgba);
	rgba2_pixel = gcpMapRGBAColor(vis, &rgba2);
	hsv_pixel = gcpMapHSVColor(vis, &hsv);
	yuv_pixel = gcpMapYUVColor(vis, &yuv);
	cmyk_pixel = gcpMapCMYKColor(vis, &cmyk);


	/* Change this, if you want to test color-blending
	 * with different colorspaces.
	 */
	col1_pixel = rgba_pixel;
	col2_pixel = rgba2_pixel;
	col3_pixel = cmyk_pixel;


	printf("color1 pixel: %i\n", col1_pixel);
	printf("color2 pixel: %i\n", col2_pixel);
	printf("color3 pixel: %i\n", col3_pixel);



	ggiSetGCForeground(vis, col1_pixel);
	ggiDrawBox(vis, 0,0, 100,100);

	ggiSetGCForeground(vis, col2_pixel);
	ggiDrawBox(vis, 101,0, 100,100);

	ggiSetGCForeground(vis, col3_pixel);
	ggiDrawBox(vis, 201,0, 100,100);



	ggiSetGCForeground(vis, col1_pixel);
	ggiDrawBox(vis, 0,110, 200,100);

	ggiFlush(vis);

	for (i = 0, j = 0; i < 200; i++) {
		j = (int)((ggi_float)(i / 200.0f) * 65536);
		blend_pixel = gcpBlendColor(vis, &col1_pixel, &col2_pixel, j);

#if 0
		printf("alpha: %i, blend_pixel: %i\n", j, blend_pixel);
#endif

		ggiSetGCForeground(vis, blend_pixel);
		ggiDrawVLine(vis, i, 110, 100);

		ggiFlush(vis);
		if (ggiKbhit(vis)) break;
	}	/* for */


	ggiSetGCForeground(vis, col2_pixel);
	ggiDrawBox(vis, 0,210, 200,100);

	ggiFlush(vis);


	for (i = 0, j = 0; i < 200; i++) {
		j = (int)((ggi_float)(i / 200.0f) * 65536);
		blend_pixel = gcpBlendColor(vis, &col2_pixel, &col3_pixel, j);

#if 0
		printf("alpha: %i, blend_pixel: %i\n", j, blend_pixel);
#endif

		ggiSetGCForeground(vis, blend_pixel);
		ggiDrawVLine(vis, i, 210, 100);

		ggiFlush(vis);
		if (ggiKbhit(vis)) break;
	}	/* for */

	ggiSetGCForeground(vis, col3_pixel);
	ggiDrawBox(vis, 0,310, 200,100);

	ggiFlush(vis);


	for (i = 0, j = 0; i < 200; i++) {
		j = (int)((ggi_float)(i / 200.0f) * 65536);
		blend_pixel = gcpBlendColor(vis, &col3_pixel, &col1_pixel, j);

#if 0
		printf("alpha: %i, blend_pixel: %i\n", j, blend_pixel);
#endif

		ggiSetGCForeground(vis, blend_pixel);
		ggiDrawVLine(vis, i, 310, 100);

		ggiFlush(vis);
		if (ggiKbhit(vis)) break;
	}	/* for */


	ggiGetc(vis);
}	/* do_demo */



int main(void)
{
	ggi_visual_t vis;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize LibGCP extension */
	if (gcpInit() != 0) {
		ggiPanic("Unable to initialize LibGCP extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}
	
	/* Attach the GCP extension to the visual */
	if (gcpAttach(vis) < 0) {
		ggiPanic("Unable to attach EDEMO extension to visual\n");
	}


	do_demo(vis);

	
	/* Detach extension from visual */
	gcpDetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize LibGCP extension */
	gcpExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
