/*
 * $Id: tinfo.h,v 1.12 2000/11/29 01:53:36 doviende Exp $
 */

#if !defined(__include_tinfo_h__)
#define __include_tinfo_h__

#include <sys/types.h>

#include "types.h"

/* tinfo.h is the terminfo database interface.
 */

/* struct tinfo_entry is an entry from an open terminfo file.  It needs to be
 * used when retrieving terminfo data.
 */
struct tinfo_seek;
extern struct tinfo_entry {
	struct tinfo_seek **seek_list;	/* list of capability offsets */
	u_long offset;			/* offset of entry, relative to start of
					   file. */
	int fd;				/* file descriptor of file */
	struct te_hdr {			/* file header */
		int16_t magic,		/* file magic */
			name_len,	/* length of terminal type string */
			bool_size,	/* size of boolean cap. section */
			num_size,	/* number of integer capabilities */
			str_size,	/* number of string offsets */
			str_table_size;	/* size of string offset table */
	} hdr;
	char *names;			/* list of terminal entries */
	struct te_caps {		/* capabilities */
		int8_t *bool;		/* booleans */
		int16_t *nums;		/* numbers */
		int16_t *str_offsets;	/* string offsets */
		char *str_table;	/* string table */
	} caps;
} *tc_entry;

extern void kill_tc_entry(void);

extern char *tinfo_getstr(struct tinfo_entry *_en, int _offset);
extern int tinfo_getflag(struct tinfo_entry *_en, int _offset);
extern int tinfo_getnum(struct tinfo_entry *_en, int offset);

extern int tinfo_init(char *_term);

/* mbyte_pairs[] is a list of terminals that support multibyte character pairs.
 * tinfo_mbyte_pairs != NULL if the current $TERM is one of mbyte_pairs[].
 */
extern struct mbyte_pair {
	const char *term;	/* $TERM value */
	int r1, r2;		/* range start, end */
} mbyte_pairs[], *term_mbyte_pairs;

#endif
