/*
 *  html.h
 *  mod_musicindex
 *
 *  $Id: html.h,v 1.24 2004/07/06 17:56:13 varenet Exp $
 *
 *  Created by Thibaut VARENE on Thu Mar 20 2003.
 *  Copyright (c) 2003-2004 Regis BOUDIN
 *  Copyright (c) 2003-2004 Thibaut VARENE
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1, or (at your option)
 *  any later version.
 *
 */

#ifndef HTML_H
#define HTML_H

#include "mod_musicindex.h"
#include <string.h>
#include <unistd.h>
#include <ctype.h>	/* isdigit() */

#define MAX_PREFIX	256	/**< Maximum expected size of the URL "prefix" (user\@host stuff). */
#define DIRPERLINE	3	/**< Number of directories to show per line */

void treat_args(request_rec *r, mu_config *conf);
void send_head(request_rec *r, mu_config *conf);
void send_directories(request_rec *r, mu_ent *p, mu_config *conf);
void send_tracks(request_rec *r, mu_ent *p, mu_config *conf);
void send_playlist(request_rec *r, mu_ent *p, mu_config *conf);
void send_foot(request_rec *r, mu_config *conf);
void send_result(request_rec *r, mu_ent *p, mu_config *conf);
void send_customlist(request_rec *r, mu_ent *p, mu_config *conf);
void send_rss(request_rec *r, mu_ent *p, mu_config *conf);

	
#endif	/* HTML_H */
