/**
 * \file qt2/FileDialog.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include <config.h>

#include "commandtags.h"
#include "LString.h"
#include "frontends/FileDialog.h"
#include "FileDialog_private.h"
#include "debug.h"
#include "qt_helpers.h"
#include "gettext.h"

#include <qapplication.h>

#include <utility>

using std::make_pair;
using std::pair;
using std::endl;


struct FileDialog::Private {
	Button b1;
	Button b2;
};


FileDialog::FileDialog(LyXView * lv, string const & t,
		       kb_action s, Button b1, Button b2)
	: private_(new FileDialog::Private), lv_(lv), title_(t), success_(s)
{
	private_->b1 = b1;
	private_->b2 = b2;
}


FileDialog::~FileDialog()
{
	delete private_;
}


FileDialog::Result const FileDialog::save(string const & path,
					    string const & mask,
					    string const & suggested)
{
	string filter(mask);
	if (mask.empty())
		filter = _("All files (*)");

	LyXFileDialog dlg(path, filter, title_, private_->b1, private_->b2);
	lyxerr[Debug::GUI] << "Select with path \"" << path
			   << "\", mask \"" << filter
			   << "\", suggested \"" << suggested << endl;

	dlg.setMode(QFileDialog::AnyFile);

	if (!suggested.empty())
		dlg.setSelection(toqstr(suggested));

	FileDialog::Result result;
	lyxerr[Debug::GUI] << "Synchronous FileDialog: " << endl;
	result.first = FileDialog::Chosen;
	int res = dlg.exec();
	lyxerr[Debug::GUI] << "result " << res << endl;
	if (res == QDialog::Accepted)
		result.second = fromqstr(dlg.selectedFile());
	dlg.hide();
	return result;
}


FileDialog::Result const FileDialog::open(string const & path,
					    string const & mask,
					    string const & suggested)
{
	string filter(mask);
	if (mask.empty())
		filter = _("All files (*)");

	LyXFileDialog dlg(path, filter, title_, private_->b1, private_->b2);
	lyxerr[Debug::GUI] << "Select with path \"" << path
			   << "\", mask \"" << filter
			   << "\", suggested \"" << suggested << endl;

	if (!suggested.empty())
		dlg.setSelection(toqstr(suggested));

	FileDialog::Result result;
	lyxerr[Debug::GUI] << "Synchronous FileDialog: " << endl;
	result.first = FileDialog::Chosen;
	int res = dlg.exec();
	lyxerr[Debug::GUI] << "result " << res << endl;
	if (res == QDialog::Accepted)
		result.second = fromqstr(dlg.selectedFile());
	dlg.hide();
	return result;
}


FileDialog::Result const FileDialog::opendir(string const & path,
					    string const & suggested)
{
	string filter = _("Directories");

	LyXFileDialog dlg(path, filter, title_, private_->b1, private_->b2);
	lyxerr[Debug::GUI] << "Select with path \"" << path
			   << "\", suggested \"" << suggested << endl;

	dlg.setMode(QFileDialog::DirectoryOnly);

	if (!suggested.empty())
		dlg.setSelection(toqstr(suggested));

	FileDialog::Result result;
	lyxerr[Debug::GUI] << "Synchronous FileDialog: " << endl;
	result.first = FileDialog::Chosen;
	int res = dlg.exec();
	lyxerr[Debug::GUI] << "result " << res << endl;
	if (res == QDialog::Accepted)
		result.second = fromqstr(dlg.selectedFile());
	dlg.hide();
	return result;
}