/*
 * $Id: zmalloc.c,v 1.6 2000/06/27 13:07:28 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 *  zmalloc.c
 *		
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */


#include <config.h>

#ifndef __vax__
#include <stddef.h>
#else
#include <sys/types.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#else
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#endif

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#include <strings.h>
/* memory.h and strings.h conflict on some systems.  */
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#ifdef __vax__
#define __SIZE_T is defined in string.h
#define __WCHAR_T is defined in stdlib.h
#endif
#include "zmalloc.h"

#undef DEBUG_ZALLOC
#ifdef DEBUG_ZALLOC
#include <stdio.h>
static void backtrace(void) { };
#endif
#define EXPORT


typedef	struct	{
	int		refcount;
	size_t		size;
}  z_info;



#define	REFCOUNT(pointer)	\
	(((z_info *) ((char *) pointer - sizeof (z_info)))->refcount)

#define	AREA_SIZE(pointer)	\
	(((z_info *) ((char *) pointer - sizeof (z_info)))->size)


#define MIN(n1, n2)		(((n1) < (n2)) ? (n1) : (n2))



EXPORT  void *
zmalloc (size_t	   size)
{
    void		* memory;

    memory = (void *) malloc (size + sizeof (z_info));
    if (memory == NULL)
	return  NULL;
    ((z_info *) memory)->size = size;
    ((z_info *) memory)->refcount = 1;
#ifdef DEBUG_ZALLOC
    fprintf(stderr, "DEBUG_ZALLOC: zmalloc: %10d %p  1\n",
	   size, (char *) memory + sizeof (z_info));
    backtrace();
#endif
    return  (char *) memory + sizeof (z_info);
}



EXPORT  void *
zcalloc (size_t	   n,
	 size_t	   size)

{
    void		* memory;

    memory = (void *) malloc (n * size + sizeof (z_info));
    if (memory == NULL)
	return  NULL;
    ((z_info *) memory)->size = n * size;
    ((z_info *) memory)->refcount = 1;
    memset ((char *) memory + sizeof (z_info),
	    0, n * size);

#ifdef DEBUG_ZALLOC
    fprintf(stderr, "DEBUG_ZALLOC: zcalloc: %5d*%4d %p 1\n",
	   n, size, (char *) memory + sizeof (z_info));
    backtrace();
#endif
    return  (char *) memory + sizeof (z_info);
}



EXPORT  void *
zrealloc (void	  * ptr,
	  size_t    size)

{
    void		* memory;

    if (ptr == NULL)
	return  zmalloc (size);
    if (REFCOUNT (ptr) > 1)
    {
#ifdef DEBUG_ZALLOC
	fprintf(stderr, "DEBUG_ZALLOC: zrealloc: clones to zmalloc:\n");
	backtrace();
#endif
	memory = zmalloc (size);
	if (memory == NULL)
	    return  NULL;
	memcpy (memory, ptr, MIN (size, AREA_SIZE (ptr)));
	--REFCOUNT (ptr);

	return  memory;
    }
    else
    {
	memory = (void *) realloc ((char *) ptr - sizeof (z_info),
			  size + sizeof (z_info));
#ifdef DEBUG_ZALLOC
	fprintf(stderr, "DEBUG_ZALLOC: zrealloc:%10d %p 1 (was %p)\n",
	       size, (char *) memory + sizeof (z_info), ptr);
	backtrace();
#endif
	return  (char *) memory + sizeof (z_info);
    }
}



EXPORT  void
zfree (void	* ptr)
{
    if (ptr != NULL && --REFCOUNT (ptr) <= 0)
    {
#ifdef DEBUG_ZALLOC
	fprintf(stderr, "DEBUG_ZALLOC: zfree:   %10d %p 0\n",
	       AREA_SIZE(ptr), (char *) ptr);
	backtrace();
#endif
	free ((char *) ptr - sizeof (z_info));
    }
#ifdef DEBUG_ZALLOC
    else if (ptr != NULL)
    {
	fprintf(stderr, "DEBUG_ZALLOC: zfree:   %10d %p %4d\n",
	       AREA_SIZE(ptr), (char *) ptr, REFCOUNT(ptr));
	backtrace();
    }
#endif
}



EXPORT  void
zdestruct (void	  * ptr)
{
    if (ptr != NULL)
	free ((char *) ptr - sizeof (z_info));
}



EXPORT  void *
zuse (void	* ptr)
{
    if (ptr != NULL)
    {
	++REFCOUNT (ptr);
#ifdef DEBUG_ZALLOC
	fprintf(stderr, "DEBUG_ZALLOC: zuse:    %10d %p %4d\n",
	       AREA_SIZE(ptr), (char *) ptr, REFCOUNT(ptr));
	backtrace();
#endif
    }
    return  ptr;
}



EXPORT  void *
zown (void	* ptr)
{
    void	* memory;

    if (ptr == NULL)
	return  NULL;
    if (REFCOUNT (ptr) == 1)
	return  ptr;
    else
    {
	if ((memory = (void *) malloc (AREA_SIZE (ptr))) == NULL)
	    return  NULL;
	memcpy (memory, ptr, AREA_SIZE (ptr));
	zfree (ptr);

	return  memory;
    }
}
